# ~/.bashrc: executed by bash(1) for non-login shells.
# see /usr/share/doc/bash/examples/startup-files (in the package bash-doc)
# for examples

# If not running interactively, don't do anything
[ -z "$PS1" ] && return

# don't put duplicate lines in the history. See bash(1) for more options
# don't overwrite GNU Midnight Commander's setting of `ignorespace'.
HISTCONTROL=$HISTCONTROL${HISTCONTROL+:}ignoredups
# ... or force ignoredups and ignorespace
HISTCONTROL=ignoreboth

# append to the history file, don't overwrite it
shopt -s histappend

# for setting history length see HISTSIZE and HISTFILESIZE in bash(1)

# check the window size after each command and, if necessary,
# update the values of LINES and COLUMNS.
shopt -s checkwinsize

# make less more friendly for non-text input files, see lesspipe(1)
#[ -x /usr/bin/lesspipe ] && eval "$(SHELL=/bin/sh lesspipe)"

# set a fancy prompt (non-color, unless we know we "want" color)
case "$TERM" in
    xterm-color) color_prompt=yes;;
esac

if [ -f /etc/cores.defs ]; then
    . /etc/cores.defs
    if [ -x /usr/bin/git ]; then
        if [ -f .git-completion.bash ]; then
            . .git-completion.bash
        fi
        
        if [ -f .git-prompt.sh ]; then
            . .git-prompt.sh
            # Configure the GIT_PS1 parameters (looks cooler! :P)
            export GIT_PS1_SHOWDIRTYSTATE=1
            export GIT_PS1_SHOWSTASHSTATE=1
            export GIT_PS1_SHOWUNTRACKEDFILES=1
            export GIT_PS1_SHOWUPSTREAM="auto verbose"
            export GIT_PS1_SHOWCOLORHINTS=1
        fi
        # And set __git_ps1 variable
        PS1="${TAMARELOB}[${TVERDEB}\u${TAMARELOB}@${TVERMELHOB}\h${TROSAB}\$(__git_ps1) ${TBRANCOB}\W${TAMARELOB}]${TCIANOB}\\$ $RESET"
    else
        # If we don't have git, just use our cool themed prompt
        PS1="${TAMARELOB}[${TVERDEB}\u${TAMARELOB}@${TVERMELHOB}\h ${TBRANCOB}\W${TAMARELOB}]${TCIANOB}\\$ $RESET"
    fi
else
    # If no git and no themes available, then use Debian's default color prompt
    PS1='\u@\h \$(__git_ps1) \w \\$ '
fi

# enable color support of ls and also add handy aliases
if [ -x "$(which gnuls)" ]; then
    alias ls='gnuls --color=auto'
fi

alias ll='ls -lha'
alias l='ls -lh'
alias grep='grep --color=auto'
alias fgrep='fgrep --color=auto'
alias egrep='egrep --color=auto'
alias vi='vim'
alias top='htop'
alias free='freecolor -m -t'
alias df='df -h'
alias du='du -h'

# enable programmable completion features (you don't need to enable
# this, if it's already enabled in /etc/bash.bashrc and /etc/profile
# sources /etc/bash.bashrc).
if [ -f /usr/local/share/bash-completion/bash_completion.sh ] && ! shopt -oq posix; then
    . /usr/local/share/bash-completion/bash_completion.sh
fi

