#!/bin/bash

echo -e "Defining GIT configurations"
git config --global core.editor "/usr/bin/vim" && echo "vim [OK]"
git config --global push.default upstream && echo "push.default [OK]"
git config --global merge.conflictstyle diff3 && echo "diff3 [OK]"
git config --global core.excludesfile '~/.gitignore_global' && echo "gitignore_global [OK]"

echo ""
echo "Git configurations set!"
echo "You can comment this block inside your .profile file:

# --------------------------------------
# Run GIT configurations file 
# (you can comment me after first run!)
if [ -f .git-configs-runme_before.sh ]; then
	. .git-configs-runme_before.sh
fi
# --------------------------------------

"
