/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: global.h
 * Description: global declarations
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#ifndef _GLOBAL_H
#define _GLOBAL_H 1


#include "hp48.h"


#define PROGNAME        PACKAGE" - "VERSION" (GTK)"
#define VERSION_MAJOR   0
#define VERSION_MINOR   5
#define PATCHLEVEL      0
#define COMPILE_VERSION 0

#define AUTHOR_NAME_1   "(c) 1994 - Eddie C. Dost"
#define AUTHOR_EMAIL_1  "<ecd@dressler.de>"
#define AUTHOR_1        AUTHOR_NAME_1" "AUTHOR_EMAIL_1
#define AUTHOR_NAME_2   "(c) 1998 - Iigo Serna"
#define AUTHOR_EMAIL_2  "<imaseroi@bi.ehu.es>"
#define AUTHOR_2        AUTHOR_NAME_2" "AUTHOR_EMAIL_2

/* Header for saturn file */
#define X48_MAGIC       0x48503438

#define NUMBUTTONS      10
#define NUMKEYS         49

/* Files */
#define X48HOMEDIR      ".x48"

#define ROM_SX_FILE     "data/rom.48s"
#define ROM_GX_FILE     "data/rom.48g"

#define SATURN_SX_FILE  "hp48.48s"
#define SATURN_GX_FILE  "hp48.48g"
#define PORT0_SX_FILE   "port0.48s"
#define PORT0_GX_FILE   "port0.48g"
#define PORT1_SX_FILE   "port1.48s"
#define PORT1_GX_FILE   "port1.48g"
#define PORT2_SX_FILE   "port2.48s"
#define PORT2_GX_FILE   "port2.48g"

#define X48RC_FILE  X48HOMEDIR"/x48.cfg"


/**************************************************************/

/* general */
extern char        *x48name, x48exedir[], homedir[], x48dir[];
extern int         state, change_state, end;
extern int         wake;

extern struct      keys_t keys[];

/* options */
extern int         opt_initialize, opt_reset;
extern int         opt_gx;
extern int         opt_show_intro, opt_verbose;
extern int         opt_ask_save, opt_save, opt_save_cfg;
extern int         opt_debug, opt_mnemonics_hp;
extern int         opt_serial, opt_terminal;
extern char        opt_serial_line[];
extern int         opt_port1w, opt_port2w;
extern int         opt_time_accurate, opt_timer1_period;

extern int         force_save, force_save_cfg;
extern char        terminal_line[];

/* hp48.h */
extern saturn_t	   saturn;
extern device_t    device;
extern display_t   display;
extern int	   got_alarm;
extern int	   set_t1;
extern long	   sched_timer1;
extern long	   sched_timer2;
extern int	   adj_time_pending;
extern long	   sched_adjtime;
extern long	   schedule_event;


/**************************************************************/

/* actions.c */
extern void    do_kbd_int();
extern void    do_interupt();

/* device.c */
extern void    check_devices();

/* emulate.c */
extern void    prepare_emulation();
extern void    emulate();
extern void    finish_int();

/* init.c */
extern int     init_emulator();
extern int     exit_emulator();
extern int     write_files();

/* lcd.c */
extern void    init_display();
extern void    update_display();
extern void    disp_draw_nibble( word_20 addr, word_4 val );
extern void    menu_draw_nibble( word_20 addr, word_4 val );

/* memory.c */
extern void    dev_memory_init();
extern void    (*write_nibble) ( long addr, int val );
extern int     (*read_nibble) ( long addr );
extern int     (*read_nibble_crc) ( long addr );
extern long    read_nibbles( long addr, int len );
extern void    write_nibbles( long addr, long val, int len );

/* options.c */
extern int     write_x48rc();
extern int     parse_x48rc();
extern int     parse_args();
extern void    show_options();
extern void    usage();
extern int     error( char *text );

/* rpl.c */
extern word_20 RPL_Pick( int l );
extern int     LoadObject( char *filename );
extern int     SaveObject( word_20 obj, char *filename );

/* serial.c */
extern int     init_serial();
extern void    serial_baud();
extern void    transmit_char();
extern void    receive_char();

/* x48_gtk.c */
extern int     init_gtk( int argc, char *argv[] );
extern int     create_windows();
extern void    exit_gtk();

extern void    draw_nibble( int c, int r, int val );

extern void    execute();

/* x48_gtk.menu.c */
extern void    menu_about();


#endif /* _GLOBAL_H */
