/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: hp48.h
 * Description: saturn internal structures and registers
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#ifndef _HP48_H
#define _HP48_H 1


#include <sys/time.h>


/*********
 * mmu.h *
 *********/
#define NR_MCTL		6

#define MCTL_MMIO_SX	0
#define MCTL_SysRAM_SX	1
#define MCTL_PORT1_SX	2
#define MCTL_PORT2_SX	3
#define MCTL_EXTRA_SX	4
#define MCTL_SysROM_SX	5

#define MCTL_MMIO_GX	0
#define MCTL_SysRAM_GX	1
#define MCTL_BANK_GX	2
#define MCTL_PORT1_GX	3
#define MCTL_PORT2_GX	4
#define MCTL_SysROM_GX	5


/**********
 * hp48.h *
 **********/

#define ROM_SIZE_SX 0x080000
#define RAM_SIZE_SX 0x010000
#define ROM_SIZE_GX 0x100000
#define RAM_SIZE_GX 0x040000

#define P_FIELD          0
#define WP_FIELD         1
#define XS_FIELD         2
#define X_FIELD          3
#define S_FIELD          4
#define M_FIELD          5
#define B_FIELD          6
#define W_FIELD          7
#define A_FIELD         15
#define IN_FIELD        16
#define OUT_FIELD       17
#define OUTS_FIELD      18

#define DEC             10
#define HEX             16

#define NR_RSTK		 8
#define NR_PSTAT	16


typedef unsigned char  word_1;
typedef unsigned char  word_4;
typedef unsigned char  word_8;
typedef unsigned short word_12;
typedef unsigned short word_16;
typedef long	       word_20;
typedef long	       word_32;
typedef struct word_64 {
                          unsigned long hi, lo;
                       } word_64;


/* keystate struct */
typedef struct keystate_t
                          {
                             short rows[9];
                          } keystate_t;


/* display struct */
#define DISP_ROWS               64
#define NIBBLES_PER_ROW         0x22
#define NIBS_PER_BUFFER_ROW     (NIBBLES_PER_ROW + 2)
typedef struct display_t {

  int  on;                      /* display active */
  long disp_start;              /* start address of display grob */
  long disp_end;                /* end address of display grob */
  int  offset;
  int  lines;
  int  nibs_per_line;
  int  contrast;                /* contrast setting */
  long menu_start;              /* start address of menu grob */
  long menu_end;                /* end address of menu grob */
  int  annunc;                  /* annunciator setting */

  signed int disp_buf[DISP_ROWS][NIBS_PER_BUFFER_ROW];

} display_t;


/* memory control struct */
typedef struct mem_cntl_t {
                             short unconfigured;
                             word_20 config[2];
                          } mem_cntl_t;


/* saturn struct */
typedef struct saturn_t {

  unsigned long magic;
  char          version[4];

  unsigned char A[16], B[16], C[16], D[16];

  word_20       d[2];
#define D0	d[0]
#define D1	d[1]

  word_4        P;
  word_20       PC;

  unsigned char R0[16], R1[16], R2[16], R3[16], R4[16];
  unsigned char IN[4];
  unsigned char OUT[3];

  word_1        CARRY;

  unsigned char PSTAT[NR_PSTAT];
  unsigned char XM, SB, SR, MP;

  word_4	hexmode;

  word_20	rstk[NR_RSTK];
  short         rstkp;

  keystate_t    keybuf;

  unsigned char intenable;
  unsigned char int_pending;
  unsigned char kbd_ien;

  word_4	disp_io;

  word_4	contrast_ctrl;
  word_8	disp_test;

  word_16	crc;

  word_4	power_status;
  word_4	power_ctrl;

  word_4	mode;

  word_8	annunc;

  word_4	baud;

  word_4	card_ctrl;
  word_4	card_status;

  word_4	io_ctrl;
  word_4	rcs;
  word_4	tcs;

  word_8	rbr;
  word_8	tbr;

  word_8	sreq;

  word_4	ir_ctrl;

  word_4	base_off;

  word_4	lcr;
  word_4	lbr;

  word_4	scratch;

  word_4	base_nibble;

  word_20       disp_addr;
  word_12       line_offset;
  word_8	line_count;

  word_16       unknown;

  word_4	t1_ctrl;
  word_4	t2_ctrl;

  word_20       menu_addr;

  word_8	unknown2;

  char		timer1;		/* may NOT be unsigned !!! */
  word_32	timer2;

  long		t1_instr;
  long		t2_instr;

  short		t1_tick;
  short		t2_tick;
  long		i_per_s;

  short		bank_switch;
  mem_cntl_t	mem_cntl[NR_MCTL];

  unsigned char *rom;
  unsigned char *ram;
  unsigned char *port1;
  unsigned char *port2;

} saturn_t;


/**********
 * device *
 **********/
typedef struct device_t {

  int  display_touched;

  char contrast_touched;

  char disp_test_touched;
 
  char crc_touched;

  char power_status_touched;
  char power_ctrl_touched;

  char mode_touched;

  char ann_touched;
 
  char baud_touched;

  char card_ctrl_touched;
  char card_status_touched;

  char ioc_touched;

  char tcs_touched;
  char rcs_touched;

  char rbr_touched;
  char tbr_touched;

  char sreq_touched;

  char ir_ctrl_touched;

  char base_off_touched;

  char lcr_touched;
  char lbr_touched;

  char scratch_touched;
  char base_nibble_touched;
  
  char unknown_touched;

  char t1_ctrl_touched;
  char t2_ctrl_touched;

  char unknown2_touched;

  char t1_touched;
  char t2_touched;

} device_t;


#endif /* !_HP48_H */
