/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: main.c
 * Description: main file init and prepare data
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#include <config.h>
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "global.h"
#include "hp48.h"


/***************
 * Global data *
 ***************/

/* emulator state */
int      wake  = 1;

/* hardware */
device_t  device;
display_t display;
saturn_t  saturn;

 /* default options */
int      opt_initialize = 0;
int      opt_reset = 0;
int      opt_verbose = 1;
int      opt_gx = 1;
int      opt_show_intro = 1;
int      opt_ask_save = 0;
int      opt_save = 1;
int      opt_save_cfg = 1;
int      opt_serial = 0;
char     opt_serial_line[50] = "/dev/cua1";
int      opt_terminal = 0;
int      opt_debug = 0;
int      opt_mnemonics_hp = 1;
int      opt_port1w = 0;
int      opt_port2w = 0;
int      opt_time_accurate = 0;
int      opt_timer1_period = 0;

int      force_save = 0, force_save_cfg = 0;
char     terminal_line[50] = "/dev/tty";

/* directories */
char     *x48name, x48exedir[256], x48dir[256], homedir[256];


/*************
 * Functions *
 *************/

/******************
 * signal_handler *
 ******************/
void signal_handler( int sig )
{
   switch( sig )
   {
      case SIGALRM:
         got_alarm = 1;
         break;
      default:
         break;
   }
}


/********
 * Main *
 ********/
int main(int argc, char *argv[])
{
   int              i;
   char             *res, *buf, *buf2;
   struct passwd    *pwd;
   sigset_t         set;
   struct sigaction sa;
   struct itimerval it;


   /****************
    * Presentation *
    ****************/
   printf( "\n\n\t\t\t%s\n\t\t\t", PROGNAME );
   for( i = 1; i < sizeof(PROGNAME); i++ )
      printf( "-" );

   printf( "\n\nCopyright\t%s\n\t\t%s\n\n", AUTHOR_1, AUTHOR_2 );


   /**************************
    * Get useful information *
    **************************/
   res = getenv( "HOME" );
   if( res )
      strcpy( homedir, res );
   else
   {
      pwd = getpwuid( getuid() );
      if( pwd )
         strcpy( homedir, pwd->pw_dir );
   }
   strcat( homedir, "/" );
                                           
   if( !( x48name = (char *) strrchr(argv[0], '/') ) )
      x48name = argv[0];
   else
      x48name++;
   buf = argv[0];
   buf2 = x48exedir;
   while( buf < x48name )
      *buf2++ = *buf++;

   sprintf( x48dir, "%s/%s-%s/", DATADIR, PACKAGE, VERSION );

   /************
    * Init GTK *
    ************/
   if( init_gtk(argc, argv) )
   {
      fprintf( stderr, "%s: ERROR: Can't initialize GTK\n", x48name );
      exit(0);
   }

   /***************
    * Get options *
    ***************/
   parse_x48rc();
   if( parse_args( argc, argv ) )
   {
      fprintf( stderr, "%s:\tERROR: parsing command line.\n", x48name );
      exit_gtk();
      exit(0);
   }
   if( opt_verbose )
      show_options();

   /**************
    * About show *
    **************/
   if( opt_show_intro )
      menu_about();

   /*****************
    * A little wait *
    *****************/
   if( opt_verbose )
      printf( "%s:\tInitializing data, please wait a moment.\n\n",
              x48name );

   /***************************
    * Create the HP-48 window *
    ***************************/
   if( create_windows() )
   {
      fprintf( stderr, "%s: ERROR: Can't create windows\n", x48name );
      exit_gtk();
      exit(0);
   }

   /*****************************
    * Initialize emulator stuff *
    *****************************/
    init_emulator();

   /*********************************
    * Install a handler for SIGALRM *
    *********************************/
   sigemptyset( &set );
   sigaddset( &set, SIGALRM );
   sa.sa_handler = signal_handler;
   sa.sa_mask = set;
#ifdef SA_RESTART
   sa.sa_flags = SA_RESTART;
#endif
   sigaction( SIGALRM, &sa, (struct sigaction *) 0 );

   /*************************************
    * Set the real time interval  timer *
    *************************************/
   it.it_interval.tv_sec = 0;
   it.it_interval.tv_usec = 20000;
   it.it_value.tv_sec = 0;
   it.it_value.tv_usec = 20000;
   setitimer( ITIMER_REAL, &it, (struct itimerval *) 0 );

   /*************
    * Emulation *
    *************/
   prepare_emulation();
   execute();

   /*******
    * End *
    *******/
   exit_emulator();
   printf( "\n" );
   exit_gtk();

   return 1;
}


/*********
 * Error *
 *********/
int error( char *text )
{
   fprintf( stderr, "%s:\t%s", x48name, text );
   exit_gtk();
   exit_emulator();
   exit(-1);
}

