/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: serial.c
 * Description: communications routines
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#if defined(LINUX) || defined(HPUX)
#include <sys/ioctl.h>
#endif
#include <unistd.h>
#include <termios.h>
#ifdef SOLARIS
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/termios.h>
#endif

#include "global.h"
#include "hp48.h"


static int wire_fd;
static int ir_fd;
static int ttyp;

extern int rece_instr;


/* #define DEBUG_SERIAL 1 */


/*****************************
 * update_connection_display *
 *****************************/
void update_connection_display()
{
   if( wire_fd == -1 )
   {
      if( opt_serial_line )
         free( opt_serial_line );
      opt_serial_line[0] = '\0';
   }
   if( ir_fd == -1 )
   {
      if( terminal_line )
         free( terminal_line );
      terminal_line[0] = '\0';
   }
}


/***************
 * init_serial *
 ***************/
int init_serial()
{
#if defined(SOLARIS) || defined (IRIX)
   char *p;
#else
   int   c;
#endif
   int   n;
   char tty_dev_name[128];
   struct termios ttybuf;

   wire_fd = -1;
   ttyp = -1;
   if( opt_terminal )
   {
#ifdef IRIX
      if( (p = _getpty(&wire_fd, O_RDWR | O_EXCL | O_NDELAY, 0666, 0)) == NULL )
      {
         wire_fd = -1;
         ttyp = -1;
      }
      else
      {
         if( (ttyp = open(p, O_RDWR | O_NDELAY, 0666)) < 0 )
         {
            close( wire_fd );
            wire_fd = -1;
            ttyp = -1;
         }
         else
         {
            if( opt_verbose )
               printf("%s:\twire connection on %s\n", x48name, p );
               terminal_line = strdup( p );
         }
      }
#else  /* IRIX */
#ifdef SOLARIS
      if( (wire_fd = open("/dev/ptmx", O_RDWR | O_NONBLOCK, 0666)) >= 0 )
      {
         grantpt( wire_fd );
         unlockpt( wire_fd );
         p = ptsname( wire_fd );
         strcpy( tty_dev_name, p );
         if( (ttyp = open(tty_dev_name, O_RDWR | O_NDELAY, 0666)) >= 0 )
         {
            ioctl( ttyp, I_PUSH, "ptem" );
            ioctl( ttyp, I_PUSH, "ldterm" );
            if( opt_verbose )
               printf( "%s:\twire connection on %s\n", x48name, tty_dev_name);
            terminal_line = strdup( tty_dev_name );
         }
      }
#else  /* SOLARIS */
#ifdef LINUX
      c = 'p';
      do
      {
         for( n = 0; n < 16; n++ )
         {
            sprintf( tty_dev_name, "/dev/pty%c%x", c, n );
            if( (wire_fd = open(tty_dev_name,
                                O_RDWR | O_EXCL | O_NDELAY, 0666)) >= 0 )
            {
               ttyp = wire_fd;
               sprintf( tty_dev_name, "/dev/tty%c%x", c, n );
               if( opt_verbose )
                  printf( "%s:\twire connection on %s\n", x48name,
                          tty_dev_name);
               strcpy( terminal_line, tty_dev_name );
               break;
            }
         }
         c++;
      }
      while( (wire_fd < 0) && (errno != ENOENT) )
         ;
#else  /* LINUX */
      /*
       * Here we go for SUNOS, HPUX
       */
      c = 'p';
      do
      {
         for( n = 0; n < 16; n++ )
         {
            sprintf( tty_dev_name, "/dev/ptyp%x", n );
            if( (wire_fd = open(tty_dev_name,
                                O_RDWR | O_EXCL | O_NDELAY, 0666)) >= 0 )
            {
               sprintf( tty_dev_name, "/dev/tty%c%x", c, n );
               if( (ttyp = open(tty_dev_name, O_RDWR | O_NDELAY, 0666)) < 0 )
               {
                  wire_fd = -1;
                  ttyp = -1;
               }
               else
               {
                  if( opt_verbose )
                     printf( "%s:\twire connection on %s\n", x48name,
                             tty_dev_name );
                  terminal_line = strdup( tty_dev_name );
                  break;
                }
            }
         }
         c++;
      } while( (wire_fd < 0) && (errno != ENOENT) );
#endif /* LINUX */
#endif /* SOLARIS */
#endif /* IRIX */
   }

   if( ttyp >= 0 )
   {
#if defined(SUNOS) || defined(HPUX)
      if( tcgetattr(ttyp, &ttybuf) < 0 )
#else
      if( ioctl(ttyp, TCGETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(wire, TCGETS) failed, errno = %d\n",
                  x48name, errno );
         wire_fd = -1;
         ttyp = -1;
      }
   }

   ttybuf.c_lflag = 0;
   ttybuf.c_iflag = 0;
   ttybuf.c_oflag = 0;
   ttybuf.c_cflag = B9600 | CS8 | CLOCAL | CREAD;
   for( n = 0; n < NCCS; n++ )
      ttybuf.c_cc[n] = 0;
   ttybuf.c_cc[VTIME] = 0;
   ttybuf.c_cc[VMIN] = 1;

   if( ttyp >= 0 )
   {
#if defined(SUNOS) || defined (HPUX)
      if( tcsetattr(ttyp, TCSANOW, &ttybuf) < 0 )
#else
      if( ioctl(ttyp, TCSETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(wire, TCSETS) failed, errno = %d\n",
                  x48name, errno );
         wire_fd = -1;
         ttyp = -1;
      }
   }

   ir_fd = -1;
   if( opt_serial )
   {
      sprintf( tty_dev_name, opt_serial_line );
      if( (ir_fd = open(tty_dev_name, O_RDWR | O_NDELAY)) >= 0 )
      {
         if( opt_verbose )
            printf( "%s:\tIR connection on %s\n", x48name, tty_dev_name );
         strcpy( opt_serial_line, tty_dev_name );
      }
   }

   if( ir_fd >= 0 )
   {
#if defined(SUNOS) || defined (HPUX)
      if( tcgetattr(ir_fd, &ttybuf) < 0 )
#else
      if( ioctl(ir_fd, TCGETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(IR, TCGETS) failed, errno = %d\n",
                  x48name, errno );
         ir_fd = -1;
      }
   }

   ttybuf.c_lflag = 0;
   ttybuf.c_iflag = 0;
   ttybuf.c_oflag = 0;
   ttybuf.c_cflag = B9600 | CS8 | CLOCAL | CREAD;
   for( n = 0; n < NCCS; n++ )
      ttybuf.c_cc[n] = 0;
   ttybuf.c_cc[VTIME] = 0;
   ttybuf.c_cc[VMIN] = 1;

   if( ir_fd >= 0 )
   {
#if defined(SUNOS) || defined(HPUX)
      if( tcsetattr(ir_fd, TCSANOW, &ttybuf) < 0 )
#else
      if( ioctl(ir_fd, TCSETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(IR, TCSETS) failed, errno = %d\n",
                  x48name, errno);
         ir_fd = -1;
      }
   }

   return 1;
}


/***************
 * serial_baud *
 ***************/
void serial_baud( int baud )
{
   int error = 0;
   struct termios ttybuf;

   if( ir_fd >= 0 )
   {
#if defined(SUNOS) || defined (HPUX)
      if( tcgetattr(ir_fd, &ttybuf) < 0 )
#else
      if( ioctl(ir_fd, TCGETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(IR,  TCGETS) failed, errno = %d\n",
                  x48name, errno);
         ir_fd = -1;
         error = 1;
      }
   }

   ttybuf.c_cflag &= ~CBAUD;

   baud &= 0x7;
   switch( baud )
   {
      case 0:	/* 1200 */
           ttybuf.c_cflag |= B1200;
           break;
      case 1:	/* 1920 */
#ifdef B1920
           ttybuf.c_cflag |= B1920;
#endif
           break;
      case 2:	/* 2400 */
           ttybuf.c_cflag |= B2400;
           break;
      case 3:	/* 3840 */
#ifdef B3840
           ttybuf.c_cflag |= B3840;
#endif
           break;
      case 4:	/* 4800 */
           ttybuf.c_cflag |= B4800;
           break;
      case 5:	/* 7680 */
#ifdef B7680
           ttybuf.c_cflag |= B7680;
#endif
           break;
      case 6:	/* 9600 */
           ttybuf.c_cflag |= B9600;
           break;
      case 7:	/* 15360 */
#ifdef B15360
           ttybuf.c_cflag |= B15360;
#endif
           break;
   }

   if( (ir_fd >= 0) && ((ttybuf.c_cflag & CBAUD) == 0) )
   {
      fprintf( stderr, "%s:\tcan't set baud rate, using 9600\n", x48name );
      ttybuf.c_cflag |= B9600;
   }

   if( ir_fd >= 0 )
   {
#if defined(SUNOS) || defined(HPUX)
      if( tcsetattr(ir_fd, TCSANOW, &ttybuf) < 0 )
#else
      if( ioctl(ir_fd, TCSETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(IR,  TCSETS) failed, errno = %d\n",
                  x48name, errno );
         ir_fd = -1;
         error = 1;
      }
   }

   if( ttyp >= 0 )
   {
#if defined(SUNOS) || defined(HPUX)
      if( tcgetattr(ttyp, &ttybuf) < 0 )
#else
      if( ioctl(ttyp, TCGETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(wire, TCGETS) failed, errno = %d\n",
                  x48name, errno );
         wire_fd = -1;
         ttyp = -1;
         error = 1;
      }
   }

   ttybuf.c_cflag &= ~CBAUD;

   baud &= 0x7;
   switch( baud )
   {
      case 0:	/* 1200 */
           ttybuf.c_cflag |= B1200;
           break;
      case 1:	/* 1920 */
#ifdef B1920
           ttybuf.c_cflag |= B1920;
#endif
           break;
      case 2:	/* 2400 */
           ttybuf.c_cflag |= B2400;
           break;
      case 3:	/* 3840 */
#ifdef B3840
           ttybuf.c_cflag |= B3840;
#endif
           break;
      case 4:	/* 4800 */
           ttybuf.c_cflag |= B4800;
           break;
      case 5:	/* 7680 */
#ifdef B7680
           ttybuf.c_cflag |= B7680;
#endif
           break;
      case 6:	/* 9600 */
           ttybuf.c_cflag |= B9600;
           break;
      case 7:	/* 15360 */
#ifdef B15360
           ttybuf.c_cflag |= B15360;
#endif
           break;
   }

   if( (ttyp >= 0) && ((ttybuf.c_cflag & CBAUD) == 0) )
   {
      fprintf( stderr, "%s:\tcan\'t set baud rate, using 9600\n", x48name );
      ttybuf.c_cflag |= B9600;
   }

   if( ttyp >= 0 )
   {
#if defined(SUNOS) || defined(HPUX)
      if( tcsetattr(ttyp, TCSANOW, &ttybuf) < 0 )
#else
      if( ioctl(ttyp, TCSETS, (char *)&ttybuf) < 0 )
#endif
      {
         fprintf( stderr, "%s:\tioctl(wire, TCSETS) failed, errno = %d\n",
                  x48name, errno );
         wire_fd = -1;
         ttyp = -1;
         error = 1;
      }
   }
   if( error )
      update_connection_display();
}


/*****************
 * transmit_char *
 *****************/
void transmit_char()
{
#ifdef DEBUG_SERIAL
   fprintf( stderr, "XMT %s\n", (saturn.ir_ctrl & 0x04) ? "IR" : "wire" );
#endif

   if( saturn.ir_ctrl & 0x04 )
   {
      if( ir_fd == -1 )
      {
         saturn.tcs &= 0x0e;
         if( saturn.io_ctrl & 0x04 )
            do_interupt();
         return;
      }
   }
   else
   {
      if( wire_fd == -1 )
      {
         saturn.tcs &= 0x0e;
         if( saturn.io_ctrl & 0x04 )
            do_interupt();
         return;
      }
   }

#ifdef DEBUG_SERIAL
   if( isprint(saturn.tbr) )
      fprintf( stderr, "-> \'%c\'\n", saturn.tbr );
   else
      fprintf( stderr, "-> %x\n", saturn.tbr );
#endif
   if( saturn.ir_ctrl & 0x04 )
   {
      if( write(ir_fd, &saturn.tbr, 1) == 1 )
      {
         saturn.tcs &= 0x0e;
         if( saturn.io_ctrl & 0x04 )
            do_interupt();
      }
      else
      {
         if( errno != EAGAIN )
            fprintf( stderr, "%s:\tserial write error: %d\n", x48name, errno );
         saturn.tcs &= 0x0e;
         if( saturn.io_ctrl & 0x04 )
            do_interupt();
      }
   }
   else
   {
      if( write(wire_fd, &saturn.tbr, 1) == 1 )
      {
         saturn.tcs &= 0x0e;
         if( saturn.io_ctrl & 0x04 )
            do_interupt();
      }
      else
      {
         if( errno != EAGAIN )
            fprintf( stderr, "%s:\tserial write error: %d\n", x48name, errno );
      }
      saturn.tcs &= 0x0e;
      if( saturn.io_ctrl & 0x04 )
         do_interupt();
   }
}

#define NR_BUFFER 256


/****************
 * receive_char *
 ****************/
void receive_char()
{
   struct timeval tout;
   fd_set rfds;
   int nfd;
   static unsigned char buf[NR_BUFFER + 1];
   static int nrd = 0, bp = 0;

#ifdef DEBUG_SERIAL
   fprintf( stderr, "RCV %s\n", (saturn.ir_ctrl & 0x04) ? "IR" : "wire" );
#endif

   rece_instr = 0;

   if( saturn.ir_ctrl & 0x04 )
   {
      if( ir_fd == -1 )
         return;
   }
   else
   {
      if( wire_fd == -1 )
         return;
   }

   if( saturn.rcs & 0x01 )
      return;

   if( nrd == 0 )
   {
      tout.tv_sec = 0;
      tout.tv_usec = 0;
      FD_ZERO( &rfds );
      if( saturn.ir_ctrl & 0x04 )
      {
         FD_SET( ir_fd, &rfds );
         nfd = ir_fd + 1;
      }
      else
      {
         FD_SET(wire_fd, &rfds);
         nfd = wire_fd + 1;
      }
      if( (nfd = select(nfd, &rfds, (fd_set *)0, (fd_set *)0, &tout)) > 0 )
      {
#ifdef DEBUG_SERIAL
         fprintf( stderr, "select = %d\n", nfd );
#endif
         if( saturn.ir_ctrl & 0x04 )
         {
            if( FD_ISSET(ir_fd, &rfds) )
            {
               nrd = read( ir_fd, buf, NR_BUFFER );
               if( nrd < 0 )
               {
                  nrd = 0;
                  return;
               }
               bp = 0;
            }
            else
               return;
         }
         else
         {
            if( FD_ISSET(wire_fd, &rfds) )
            {
               nrd = read( wire_fd, buf, NR_BUFFER );
               if( nrd < 0 )
               {
                  nrd = 0;
                  return;
               }
               bp = 0;
            }
            else
               return;
         }
      }
      else
         return;
   }
   if( nrd == 0 )
      return;
   if( !(saturn.io_ctrl & 0x08) )
   {
      nrd = 0;
      return;
   }
   saturn.rbr = buf[bp++];
   nrd--;
   saturn.rcs |= 0x01;
   if( saturn.io_ctrl & 0x02 )
      do_interupt();
}

