/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: timer.h
 * Description: ?
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#ifndef _TIMER_H
#define _TIMER_H 1

#include "global.h"
#include "hp48.h"

#define NR_TIMERS	4

#define T1_TIMER	0
#define T2_TIMER	1
#define RUN_TIMER	2
#define IDLE_TIMER	3

typedef struct t1_t2_ticks {
  unsigned long t1_ticks;
  unsigned long t2_ticks;
} t1_t2_ticks;

extern void        reset_timer( int timer );
extern void        start_timer( int timer );
extern void        restart_timer( int timer );
extern void        stop_timer( int timer );
extern word_64     get_timer( int timer );
extern long        diff_timer( word_64 *t1, word_64 *t2 );

extern t1_t2_ticks get_t1_t2();
extern void	   set_accesstime();

#endif /* !_TIMER_H */
