/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: x48_gtk.c
 * Description: things related to GTK
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#include <config.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "global.h"
#include "hp48.h"
#include "x48_gtk.h"
#include "x48_gtk_keys.h"

/* Pixmaps Files */
#include "../pixmaps/anns.xpm"	

#define HP48GX_XPM     	    "pixmaps/Hp48gx.xpm"
#define HP48SX_XPM     	    "pixmaps/Hp48sx.xpm"

#define X48ICON_XPM	    "pixmaps/x48.xpm"
#define QUESTION_XPM	    "pixmaps/question.xpm"
#define EXCLAMATION_XPM	    "pixmaps/exclamation.xpm"

#define MENU_LOADOBJ_XPM    "pixmaps/menu_loadobj.xpm"
#define MENU_SAVEOBJ_XPM    "pixmaps/menu_saveobj.xpm"
#define MENU_CLIPBOARD_XPM  "pixmaps/menu_clipboard.xpm"
#define MENU_SAVE_XPM       "pixmaps/menu_save.xpm"
#define MENU_SETTINGS_XPM   "pixmaps/menu_settings.xpm"
#define MENU_RESET_XPM      "pixmaps/menu_reset.xpm"
#define MENU_ABOUT_XPM      "pixmaps/menu_about.xpm"


/*************************************************************************/

/***************************
 * Program general widgets *
 ***************************/

/* Hp48 display */
GtkWidget       *drarea_disp;
GtkStyle        *style_disp;
GdkGC           *gc_disp;
GdkColorContext *cc_disp;
GdkColor        *color_disp, *color_pixel;

/* For Buttons */
GtkWidget       *eventbox_btn[NUMKEYS];
GtkWidget       *xpmid_btn[NUMKEYS];
GdkBitmap       *mask[NUMKEYS];

/* identify number of emulation funtion */
int          end = 0;

/* nibble maps */
struct {
          char         data[2];
          GdkPixmap    *xpm;
       } nibble_maps[16] =
{
   { { 0x00, 0x00}, NULL },
   { { 0x03, 0x03}, NULL },
   { { 0x0C, 0x0C}, NULL },
   { { 0x0F, 0x0F}, NULL },
   { { 0x30, 0x30}, NULL },
   { { 0x33, 0x33}, NULL },
   { { 0x3C, 0x3C}, NULL },
   { { 0x3F, 0x3F}, NULL },
   { { 0xC0, 0xC0}, NULL },
   { { 0xC3, 0xC3}, NULL },
   { { 0xCC, 0xCC}, NULL },
   { { 0xCF, 0xCF}, NULL },
   { { 0xF0, 0xF0}, NULL },
   { { 0xF3, 0xF3}, NULL },
   { { 0xFC, 0xFC}, NULL },
   { { 0xFF, 0xFF}, NULL }
};

/* Annunciators */
#define ANN_LEFT         0x81
#define ANN_RIGHT        0x82
#define ANN_ALPHA        0x84
#define ANN_WARNING      0x88
#define ANN_BUSY         0x90
#define ANN_IO           0xa0
struct ann_struct {
   int            bit;
   int            x;
   int            y;
   unsigned int   w;
   unsigned int   h;
   char           **data;
   GdkPixmap      *xpm;
} ann_tbl[] = {
   { ANN_LEFT, 16, 3, 15, 11, ls_xpm },
   { ANN_RIGHT, 61, 3, 15, 11, rs_xpm },
   { ANN_ALPHA, 106, 3, 15, 11, alpha_xpm },
   { ANN_WARNING, 151, 3, 15, 11, warning_xpm },
   { ANN_BUSY, 196, 3, 15, 11, busy_xpm },
   { ANN_IO, 241, 3, 15, 11, io_xpm },
   { 0 }
};


/*************************************************************************
 *************************************************************************
 ****************************** FUNCTIONS ********************************
 *************************************************************************
 *************************************************************************/

/******************************
 * init_gtk: init all GTK stuff
 ******************************/
int init_gtk( int argc, char *argv[] )
{
   gtk_init( &argc, &argv );
   return 0;
}


/**************************
 * exit_gtk: exit all GTK *
 **************************/
void exit_gtk()
{
   gtk_exit( 0 );
}


/******************************
 * Create_Windows:
 ******************************/
int create_windows()
{
   /* Icon */
   GdkPixmap    *xpm_icon;
   GdkBitmap    *mask_icon;
   /* main widgets */
   GtkWidget    *win_main, *box_main1;
   /* for all pixmaps */
   GtkStyle     *style;
#define TOOLBAR 1
#undef TOOLBAR          /***** toolbar bugged??? *****/
#ifdef TOOLBAR
   /* for toolbar */
   GtkWidget    *toolbar;
   GdkColor     *color_bg, *color_fg;
   GdkBitmap    *mask_menubtn;
   GdkPixmap    *xpm_menubtn;
   GtkWidget    *xpmid_menubtn;
#else
   /* for tooltips */
   GtkTooltips  *tooltips;
   GdkColor     *color_bg, *color_fg;
   /* for menu box */
   GtkWidget    *table_menu;
   GtkWidget    *btn_menu;
   GdkBitmap    *mask_menubtn;
   GdkPixmap    *xpm_menubtn;
   GtkWidget    *xpmid_menubtn;
#endif
   /* for calc */
   GtkWidget    *fixed;
   GdkBitmap    *mask0;
   GdkPixmap    *xpm_calc;
   GtkWidget    *xpmid_calc;
   /* for buttons ( calc keys ) */
   GdkCursor    *cursor_btn;
   /* general */
   char tmp[255];
   int i;


   /* Main window */
   win_main = gtk_widget_new( gtk_window_get_type(),
			      "GtkObject::user_data", NULL,
			      "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
			      "GtkWindow::title", PROGNAME,
			      "GtkWindow::allow_grow", FALSE,
			      "GtkWindow::allow_shrink", FALSE,
			      "GtkContainer::border_width", 0,
			      NULL);
   gtk_widget_set_usize( win_main, WIN_MAIN_WIDTH, WIN_MAIN_HEIGHT );
   /* connect keyboard events */
   gtk_signal_connect( GTK_OBJECT(win_main), "key_press_event",
                       GTK_SIGNAL_FUNC(key_event), NULL );
   gtk_signal_connect( GTK_OBJECT(win_main), "key_release_event",
                       GTK_SIGNAL_FUNC(key_event), NULL );
   gtk_widget_set_events( win_main,
                          GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK );
   gtk_widget_realize( win_main );
   gtk_signal_connect( GTK_OBJECT(win_main), "destroy",
                       GTK_SIGNAL_FUNC( x48_quit ), win_main );
   gdk_key_repeat_disable();

   /* Icon */
   style = gtk_widget_get_default_style();
   sprintf( tmp, "%s%s", x48dir, X48ICON_XPM );
   xpm_icon = gdk_pixmap_create_from_xpm( win_main->window, &mask_icon,
                                            &style->bg[GTK_STATE_NORMAL],
                                            tmp );
   gdk_window_set_icon( win_main->window, NULL, xpm_icon, mask_icon );
   gdk_window_set_icon_name( win_main->window, PROGNAME" Icon" );

   /* Box container for rest of widgets */
   box_main1 = gtk_vbox_new( FALSE, 0 );
   gtk_container_add( GTK_CONTAINER(win_main), box_main1 );
   gtk_widget_show( box_main1 );

#ifdef TOOLBAR
   /* Toolbar */
   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS );
   gtk_widget_set_usize( toolbar, WIN_MAIN_WIDTH, BOX_ICONS_HEIGHT );
   gtk_container_add( GTK_CONTAINER(box_main1), toolbar );
   gtk_widget_show( toolbar );

   gtk_toolbar_set_space_size( GTK_TOOLBAR(toolbar), 25 );

   gtk_toolbar_set_tooltips( GTK_TOOLBAR(toolbar), TRUE );
   gtk_tooltips_set_delay( GTK_TOOLBAR(toolbar)->tooltips, 750 );
   color_bg = (GdkColor *) malloc( sizeof (GdkColor) );
   color_bg->red = 255 * (65535/255);
   color_bg->green = 255 * (65535/255);
   color_bg->blue = 150 * (65535/255);
   color_bg->pixel = (gulong) ( 255*65536 + 255*256 + 150 );
   gdk_color_alloc( gtk_widget_get_colormap(win_main), color_bg );
   color_fg = (GdkColor *) malloc( sizeof (GdkColor) );
   color_fg->red = 0 * (65535/255);
   color_fg->green = 0 * (65535/255);
   color_fg->blue = 0 * (65535/255);
   color_fg->pixel = (gulong) ( 0*65536 + 0*256 + 0 );
   gtk_tooltips_set_colors( GTK_TOOLBAR(toolbar)->tooltips, color_bg, color_fg );

   style = gtk_widget_get_default_style();

   sprintf( tmp, "%s%s", x48dir, MENU_LOADOBJ_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "",
                            "Load an Hp48 object", NULL,
                            xpmid_menubtn,
                            (GtkSignalFunc) menu_load_object, NULL );

   sprintf( tmp, "%s%s", x48dir, MENU_SAVEOBJ_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "Save an Hp48 object",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(menu_save_object), NULL );

   sprintf( tmp, "%s%s", x48dir, MENU_CLIPBOARD_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "Copy screen as XPM file",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(NotYetAvailable),
                            "Copy Screen" );

   sprintf( tmp, "%s%s", x48dir, MENU_SAVE_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "Save State",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(menu_save_object), NULL );

   gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );

   sprintf( tmp, "%s%s", x48dir, MENU_SETTINGS_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "Settings",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(menu_settings), NULL );

   gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );

   sprintf( tmp, "%s%s", x48dir, MENU_RESET_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "Reset calculator",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(menu_reset), NULL );

   gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );
   gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );

   sprintf( tmp, "%s%s", x48dir, MENU_ABOUT_XPM );
   xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                             &mask_menubtn,
                                             &style->bg[GTK_STATE_NORMAL],
                                             tmp );
   xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
   gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), "", "About",
                            "", xpmid_menubtn,
                            GTK_SIGNAL_FUNC(menu_about), NULL );

#else
   /* Tooltips */
   tooltips = gtk_tooltips_new();
   gtk_tooltips_set_delay( tooltips, 750 );
   color_bg = (GdkColor *) malloc( sizeof (GdkColor) );
   color_bg->red = 255 * (65535/255);
   color_bg->green = 255 * (65535/255);
   color_bg->blue = 150 * (65535/255);
   color_bg->pixel = (gulong) ( 255*65536 + 255*256 + 150 );
   gdk_color_alloc( gtk_widget_get_colormap(win_main), color_bg );
   color_fg = (GdkColor *) malloc( sizeof (GdkColor) );
   color_fg->red = 0 * (65535/255);
   color_fg->green = 0 * (65535/255);
   color_fg->blue = 0 * (65535/255);
   color_fg->pixel = (gulong) ( 0*65536 + 0*256 + 0 );
   gtk_tooltips_set_colors( tooltips, color_bg, color_fg );

   /* Menu box */
   table_menu = gtk_table_new( 1, 10, TRUE );
   gtk_widget_set_usize( table_menu, WIN_MAIN_WIDTH, BOX_ICONS_HEIGHT );
   gtk_container_add( GTK_CONTAINER(box_main1), table_menu );
   gtk_widget_show( table_menu );
   style = gtk_widget_get_default_style();
      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 0, 1, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( menu_load_object ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Load an Hp48 object", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_LOADOBJ_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                  &mask_menubtn,
                                                  &style->bg[GTK_STATE_NORMAL],
                                                  tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 1, 2, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( menu_save_object ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Save an Hp48 object", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_SAVEOBJ_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 2, 3, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( NotYetAvailable ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Copy screen as XPM file", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_CLIPBOARD_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 3, 4, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( menu_save_state ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Save state files", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_SAVE_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 5, 6, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC(menu_settings), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Settings", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_SETTINGS_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 7, 8, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( menu_reset ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "Reset calculator", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_RESET_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );

      btn_menu = gtk_button_new();
      gtk_table_attach_defaults( GTK_TABLE(table_menu), btn_menu,
                                 9, 10, 0, 1 );
      gtk_signal_connect( GTK_OBJECT(btn_menu), "clicked",
                          GTK_SIGNAL_FUNC( menu_about ), NULL );
      gtk_widget_show( btn_menu );
      gtk_tooltips_set_tip( tooltips, btn_menu, "About", NULL );
      sprintf( tmp, "%s%s", x48dir, MENU_ABOUT_XPM );
      xpm_menubtn = gdk_pixmap_create_from_xpm( win_main->window,
                                                &mask_menubtn,
                                                &style->bg[GTK_STATE_NORMAL],
                                                tmp );
      xpmid_menubtn = gtk_pixmap_new( xpm_menubtn, mask_menubtn );
      gtk_container_add( GTK_CONTAINER(btn_menu), xpmid_menubtn );
      gtk_widget_show( xpmid_menubtn );
#endif

   /* Hp48 pixmap */
   fixed = gtk_fixed_new();
   gtk_widget_set_usize( fixed, WIN_MAIN_WIDTH, HP48_HEIGHT );
   gtk_container_add( GTK_CONTAINER(box_main1), fixed );
   gtk_widget_set_uposition( fixed, 0, BOX_ICONS_HEIGHT );
   gtk_widget_show( fixed );
   style = gtk_widget_get_style( fixed );
   sprintf( tmp, "%s%s", x48dir, opt_gx ? HP48GX_XPM : HP48SX_XPM );
   xpm_calc = gdk_pixmap_create_from_xpm( win_main->window, &mask0,
                                          &style->bg[GTK_STATE_NORMAL],
                                          tmp );
   xpmid_calc = gtk_pixmap_new( xpm_calc, mask0 );
   gtk_widget_show( xpmid_calc );
   gtk_fixed_put( GTK_FIXED(fixed), xpmid_calc, 0, 0 );

   /* Buttons pixmaps*/
   cursor_btn = gdk_cursor_new( GDK_HAND2 );
   if( !opt_gx )
   {
      keys[34].nkey_xpm = nkey35s_xpm;
      keys[39].nkey_xpm = nkey40s_xpm;
      keys[34].ykey_xpm = ykey35s_xpm;
      keys[39].ykey_xpm = ykey40s_xpm;
   }
   for( i = 0; i < NUMKEYS; i++ )
   {
      eventbox_btn[i] = gtk_event_box_new();
      gtk_signal_connect( GTK_OBJECT(eventbox_btn[i]), "button_press_event",
                          GTK_SIGNAL_FUNC(btn_event), NULL );
      gtk_signal_connect( GTK_OBJECT(eventbox_btn[i]), "button_release_event",
                          GTK_SIGNAL_FUNC(btn_event), NULL );
      gtk_widget_set_events( eventbox_btn[i],
                             GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
      gtk_widget_show( eventbox_btn[i] );

      keys[i].xpm_n = gdk_pixmap_create_from_xpm_d( win_main->window, &mask[i],
                                                    &style->bg[GTK_STATE_NORMAL],
                                                    keys[i].nkey_xpm );
      keys[i].xpm_y = gdk_pixmap_create_from_xpm_d( win_main->window, &mask[i],
                                                    &style->bg[GTK_STATE_NORMAL],
                                                    keys[i].ykey_xpm );
      xpmid_btn[i] = gtk_pixmap_new( keys[i].xpm_n, mask[i] );
      gtk_widget_show( xpmid_btn[i] );
      gtk_container_add( GTK_CONTAINER(eventbox_btn[i]), xpmid_btn[i] );

      gtk_fixed_put( GTK_FIXED(fixed), eventbox_btn[i],
                     keys[i].x, keys[i].y );

      gtk_widget_realize( eventbox_btn[i] );
      gdk_window_set_cursor( eventbox_btn[i]->window, cursor_btn );
   }
   gdk_cursor_destroy( cursor_btn );

   /* Screen area ( draw area ) */
   drarea_disp  = gtk_drawing_area_new();
   gtk_drawing_area_size( GTK_DRAWING_AREA(drarea_disp), HP48_SCREEN_WIDTH,
                          HP48_SCREEN_HEIGHT + 17 );
   gtk_signal_connect( GTK_OBJECT(drarea_disp), "expose_event",
                       (GtkSignalFunc) expose_disp, NULL );
   gtk_signal_connect( GTK_OBJECT(drarea_disp), "configure_event",
                       (GtkSignalFunc) configure_disp, NULL );
   gtk_widget_set_events( drarea_disp, GDK_EXPOSURE_MASK );
   gtk_fixed_put( GTK_FIXED(fixed), drarea_disp, HP48_SCREEN_POSX,
                  HP48_SCREEN_POSY - 17 );
   gtk_widget_show( drarea_disp );
   GTK_WIDGET_SET_FLAGS( drarea_disp, GTK_CAN_DEFAULT );
   gtk_widget_grab_default( drarea_disp );

   /* show all */
   gtk_widget_show( win_main );

   return 0;
}


/*************************************************************************
 *************************************************************************
 *************************************************************************/

/******************
 * InitNibbleMaps *
 ******************/
void InitNibbleMaps()
{
   GdkBitmap *mask;
   int i;

   /* Initialize nibble_maps */
   for( i = 0; i < 16; i++ )
      nibble_maps[i].xpm = gdk_pixmap_create_from_data( drarea_disp->window,
                                                        nibble_maps[i].data,
                                                        8, 2,
                                                        gdk_visual_get_best_depth(),
                                                        color_pixel, color_disp );

   /* Annunciators pixmap */
   for( i = 0; i < 6; i++ )
      ann_tbl[i].xpm = gdk_pixmap_create_from_xpm_d( drarea_disp->window,
                                                     &mask,
                                                     color_disp,
                                                     ann_tbl[i].data );
}


/******************
 * configure_disp *
 ******************/
int configure_disp( GtkWidget *widget, GdkEventConfigure *ev )
{
   gint n1 = 0, n2 =0;

   gc_disp = gdk_gc_new( drarea_disp->window );
   cc_disp = gdk_color_context_new( gtk_widget_get_visual(drarea_disp),
                                    gtk_widget_get_colormap(drarea_disp) );

   color_disp = (GdkColor *) malloc( sizeof(GdkColor) );
   color_disp->pixel = (gulong) 0;
   color_disp->red = 202 * (65535/255);
   color_disp->green = 221 * (65535/255);
   color_disp->blue = 92 * (65535/255);
   gdk_color_context_get_pixels( cc_disp, &color_disp->red,
                                 &color_disp->green, &color_disp->blue,
                                 1, &color_disp->pixel, &n1 );
   gdk_gc_set_background( gc_disp, color_disp );
   gdk_window_set_background( drarea_disp->window, color_disp );

   color_pixel = (GdkColor *) malloc( sizeof(GdkColor) );
   color_pixel->pixel = (gulong) 0;
   color_pixel->red = 0 * (65535/255);
   color_pixel->green = 0 * (65535/255);
   color_pixel->blue = 128 * (65535/255);
   gdk_color_context_get_pixels( cc_disp, &color_pixel->red,
                                 &color_pixel->green, &color_pixel->blue,
                                 1, &color_pixel->pixel, &n2 );
   gdk_gc_set_foreground( gc_disp, color_pixel );

   gdk_window_set_colormap( drarea_disp->window,
                            gdk_window_get_colormap(drarea_disp->window) );

   InitNibbleMaps();
   gdk_window_clear( drarea_disp->window );
   return TRUE;
}


/***************
 * expose_disp *
 ***************/
int expose_disp( GtkWidget *widget, GdkEventExpose *ev )
{
   int y, x;
   int line_length;

   draw_anns();

   for( y = 0; y < DISP_ROWS ; y++ )
   {
      line_length = NIBBLES_PER_ROW;
      if( display.offset > 3 )
         line_length += 2;
      for( x = 0; x < line_length; x++ )
         gdk_draw_pixmap( drarea_disp->window, gc_disp,
                          nibble_maps[ display.disp_buf[y][x] ].xpm,
                          0, 0, x*8, y*2+17, 8, 2 );
   }

   return FALSE;
}


/*******************
 * adjust_contrast *
 *******************/
void adjust_contrast()
{
   gint           r = 0, g = 0, b = 0, n = 0, i;
   GdkEventExpose ev;

   if( display.contrast < 0x03 )
      display.contrast = 0x03;
   else if( display.contrast > 0x13 )
      display.contrast = 0x13;

   r = (0x13 - display.contrast) * (202 / 0x10);
   g = (0x13 - display.contrast) * (221 / 0x10);
   b = 128 - ((0x13 - display.contrast) * ((128 - 92) / 0x10));
   color_pixel->pixel = (gulong) 0;
   color_pixel->red = r * (65535/255);
   color_pixel->green = g * (65535/255);
   color_pixel->blue = b * (65535/255);
   gdk_color_context_get_pixels( cc_disp, &color_pixel->red,
                                 &color_pixel->green, &color_pixel->blue,
                                 1, &color_pixel->pixel, &n );
   /* Initialize nibble maps for new colors */
   for( i = 0; i < 16; i++ )
   {
      gdk_pixmap_unref( nibble_maps[i].xpm );
      nibble_maps[i].xpm = gdk_pixmap_create_from_data( drarea_disp->window,
                                                        nibble_maps[i].data,
                                                        8, 2,
                                                        gdk_visual_get_best_depth(),
                                                        color_pixel, color_disp );
   }
   ev.type = GDK_EXPOSE;
   ev.window = drarea_disp->window;
   gtk_widget_event( drarea_disp, (GdkEvent *) &ev );
}


/*************
 * draw_anns *
 *************/
void draw_anns()
{
   int val;
   int i;

   val = display.annunc;

   for( i = 0; ann_tbl[i].bit; i++ )
      if( (ann_tbl[i].bit & val) == ann_tbl[i].bit )
         gdk_draw_pixmap( drarea_disp->window, gc_disp, ann_tbl[i].xpm,
                          0, 0, ann_tbl[i].x, ann_tbl[i].y,
                          ann_tbl[i].w, ann_tbl[i].h );
      else
         gdk_window_clear_area( drarea_disp->window,
                                ann_tbl[i].x, ann_tbl[i].y,
                                ann_tbl[i].w, ann_tbl[i].h );
}


/***************
 * draw_nibble *
 ***************/
inline void draw_nibble( int c, int r, int val )
{
   int x, y;

   x = c * 8;
   if( r <= display.lines )
      x -= display.offset;
   y = r * 2 + 17;
   val &= 0x0F;
   gdk_draw_pixmap( drarea_disp->window, gc_disp, nibble_maps[val].xpm,
                    0, 0, x, y, 8, 2 );
}


/*************************************************************************
 *************************************************************************
 *************************************************************************/

/********************
 * process_calc_key *
 ********************/
void process_calc_key( gint key, gint pressed )
{
   int code, i, r, c, all_up;

   code = keys[key].code;

   if( pressed )        /* KeyPress */
   {
      if( opt_verbose )
         fprintf( stderr, "Pressed button #%d\n", key );
      keys[key].key_down = 1;
      keys[key].pressed = 1;
      gtk_pixmap_set( GTK_PIXMAP(xpmid_btn[key]), keys[key].xpm_y, mask[key] );
      if( code == 0x8000 )
      {
         for( i = 0; i < 9; i++ )
            saturn.keybuf.rows[i] |= 0x8000;
         do_kbd_int();
      }
      else
      {
         r = code >> 4;
         c = 1 << (code & 0xF);
         if( !(saturn.keybuf.rows[r] & c) )
         {
            if( saturn.kbd_ien )
               do_kbd_int();
            saturn.keybuf.rows[r] |= c;
         }
      }
   }

   else                 /* KeyRelease */
   {
      if( opt_verbose )
         fprintf( stderr, "Unpressed button #%d\n", key );
      keys[key].key_down = 0;
      all_up = 1;
      for( i = 0; i < NUMKEYS; i++ )
         if( keys[i].pressed )
         {
            if( keys[i].key_down )
               all_up = 0;
            else
            {
               keys[i].pressed = 0;
               gtk_pixmap_set( GTK_PIXMAP(xpmid_btn[key]), keys[key].xpm_n,
                               mask[key] );
               if( code == 0x8000 )
                  for( i = 0; i < 9; i++ )
                     saturn.keybuf.rows[i] &= ~0x8000;
               else
               {
                  r = code >> 4;
                  c = 1 << (code &0xF);
                  saturn.keybuf.rows[r] &= ~c;
               }
            }
         }
      if( all_up )
         memset( &saturn.keybuf, 0, sizeof(saturn.keybuf) );
   }

   saturn.kbd_ien = 1;
}


/*************
 * key_event *
 *************/
void key_event( GtkWidget *widget, GdkEventKey *ev )
{
   gint pressed;

   wake = 1;
   pressed = (ev->type == GDK_KEY_RELEASE) ? 0 : 1;

   printf( "Key %s, time = %d, state = %d, string=%s, length=%d\n",
           pressed ? "PRESSED" : "RELEASED",
           ev->time, ev->state, ev->string, ev->length );

   if( ev->keyval >= GDK_a && ev->keyval <= GDK_x )
      process_calc_key( (gint) ev->keyval-GDK_a, pressed );
   else if( ev->keyval >= GDK_A && ev->keyval <= GDK_X )
      process_calc_key( ev->keyval-GDK_A, pressed );
   else
   switch(ev->keyval)
   {
      case GDK_y:
      case GDK_Y:               process_calc_key( 25, pressed ); break;
      case GDK_z:
      case GDK_Z:               process_calc_key( 26, pressed ); break;
      case GDK_Up:
      case GDK_KP_Up:           process_calc_key( 10, pressed ); break;
      case GDK_Left:
      case GDK_KP_Left:         process_calc_key( 15, pressed ); break;
      case GDK_Down:
      case GDK_KP_Down:         process_calc_key( 16, pressed ); break;
      case GDK_Right:
      case GDK_KP_Right:        process_calc_key( 17, pressed ); break;
      case GDK_0:
      case GDK_KP_0:            process_calc_key( 45, pressed ); break;
      case GDK_1:
      case GDK_KP_1:            process_calc_key( 40, pressed ); break;
      case GDK_2:
      case GDK_KP_2:            process_calc_key( 41, pressed ); break;
      case GDK_3:
      case GDK_KP_3:            process_calc_key( 42, pressed ); break;
      case GDK_4:
      case GDK_KP_4:            process_calc_key( 35, pressed ); break;
      case GDK_5:
      case GDK_KP_5:            process_calc_key( 36, pressed ); break;
      case GDK_6:
      case GDK_KP_6:            process_calc_key( 37, pressed ); break;
      case GDK_7:
      case GDK_KP_7:            process_calc_key( 30, pressed ); break;
      case GDK_8:
      case GDK_KP_8:            process_calc_key( 31, pressed ); break;
      case GDK_9:
      case GDK_KP_9:            process_calc_key( 32, pressed ); break;
      case GDK_Return:
      case GDK_KP_Enter:        process_calc_key( 24, pressed ); break;
      case GDK_Delete:
      case GDK_KP_Delete:       process_calc_key( 27, pressed ); break;
      case GDK_BackSpace:       process_calc_key( 28, pressed ); break;
      case GDK_slash:
      case GDK_KP_Divide:       process_calc_key( 33, pressed ); break;
      case GDK_asterisk:
      case GDK_KP_Multiply:     process_calc_key( 38, pressed ); break;
      case GDK_minus:
      case GDK_KP_Subtract:     process_calc_key( 43, pressed ); break;
      case GDK_plus:
      case GDK_KP_Add:          process_calc_key( 48, pressed ); break;
      case GDK_space:           process_calc_key( 47, pressed ); break;
      case GDK_period:
      case GDK_KP_Decimal:      process_calc_key( 46, pressed ); break;
      case GDK_Alt_L:           process_calc_key( 29, pressed ); break;
      case GDK_Shift_L:         process_calc_key( 34, pressed ); break;
      case GDK_Shift_R:         process_calc_key( 39, pressed ); break;
      case GDK_Escape:          process_calc_key( 44, pressed ); break;
      default:                  ev->type = GDK_NOTHING; wake = 0; break;
   }
   ev->type = GDK_NOTHING;
   return;
}


/*************
 * btn_event *
 *************/
void btn_event( GtkWidget *widget, GdkEventButton *ev )
{
   gint pressed, j;

   if( ev->type == GDK_2BUTTON_PRESS ||  ev->type == GDK_3BUTTON_PRESS)
      return;
   pressed = (ev->type == GDK_BUTTON_PRESS) ? 1 : 0;

   printf( "Key %s, time = %d, state = %d, button=%d, x=%f, y=%f\n",
           pressed ? "PRESSED" : "RELEASED",
           ev->time, ev->state, ev->button, ev->x, ev->y );

   for( j = 0; j < NUMKEYS; j++ )
      if( widget == eventbox_btn[j])
         break;
   if( j > NUMKEYS )
      return;
   process_calc_key( j, pressed );
}


/*************************************************************************
 *************************************************************************
 *************************************************************************/

/***********
 * execute *
 ***********/
void execute()
{
   while( !end )
   {
      if( gtk_events_pending() )
         gtk_main_iteration_do(TRUE);
      emulate();
   }
}


/*************************************************************************
 *************************************************************************
 *************************************************************************/

/************
 * x48_quit *
 ************/
int x48_quit( GtkWidget *widget, GtkWidget *win )
{  if( opt_verbose )
      printf( "\nExiting from %s\n\n", PROGNAME );
   end = 1;

   if( !opt_save && !force_save )
      if( opt_ask_save )
         if( MessageDialog2("Save State?", " Save State of X48? ", 2) )
            force_save = 1;

   gdk_key_repeat_restore();
   gtk_widget_destroy( win );
/*   gtk_exit(0); */
   return FALSE;
}

