/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: x48_gtk_dialogs.c
 * Description: some common dialogs
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#include <config.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "global.h"

#define X48ICON_XPM	    "pixmaps/x48.xpm"
#define QUESTION_XPM	    "pixmaps/question.xpm"
#define EXCLAMATION_XPM	    "pixmaps/exclamation.xpm"


int answer;


/******************
 * MessageDialog1 *
 ******************/
void MessageDialog1( char *title, char *text, int icon )
{
   GtkWidget *win_msgdlg, *table;
   GtkWidget *label, *button, *xpmid_icon;
   GtkStyle  *style;
   GdkPixmap *xpm_icon;
   GdkBitmap *mask_icon;
   int       size, cols;
   char	     tmp[50];	

   size = strlen( text );
   cols = size / 4;

   win_msgdlg = gtk_dialog_new();
   gtk_grab_add( win_msgdlg );
   gtk_widget_realize( win_msgdlg );
   gtk_signal_connect( GTK_OBJECT(win_msgdlg), "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit), NULL );
   gtk_window_position( GTK_WINDOW(win_msgdlg), GTK_WIN_POS_CENTER );
   gtk_window_set_title( GTK_WINDOW(win_msgdlg), title );
   gtk_window_set_policy( GTK_WINDOW(win_msgdlg), FALSE, FALSE, FALSE );

   table = gtk_table_new( 1, cols, TRUE );
   gtk_container_add( GTK_CONTAINER(GTK_DIALOG(win_msgdlg)->vbox), table );
   gtk_widget_show( table );

   switch( icon )
   {
      case 1:
           sprintf( tmp, "%s%s", x48dir, EXCLAMATION_XPM );
           break;
      case 2:
           sprintf( tmp, "%s%s", x48dir, QUESTION_XPM );
           break;
      default:
           sprintf( tmp, "%s%s", x48dir, X48ICON_XPM );
           break;
   }
   style = gtk_widget_get_default_style();

   xpm_icon = gdk_pixmap_create_from_xpm( win_msgdlg->window, &mask_icon,
                                          &style->bg[GTK_STATE_NORMAL],
                                          tmp );
   xpmid_icon = gtk_pixmap_new( xpm_icon, mask_icon );
   gtk_table_attach_defaults( GTK_TABLE(table), xpmid_icon, 0, 1, 0, 1 );
   gtk_widget_show( xpmid_icon );

   label = gtk_label_new( text );
   gtk_misc_set_padding( GTK_MISC(label), size/2, 15 );
   gtk_table_attach_defaults( GTK_TABLE(table), label, 1, cols, 0, 1 );
   gtk_widget_show( label );

   button = gtk_button_new_with_label( "Ok" );
   gtk_signal_connect_object( GTK_OBJECT(button), "clicked",
		    	      GTK_SIGNAL_FUNC(gtk_widget_destroy),
                    	      GTK_OBJECT(win_msgdlg) );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX(GTK_DIALOG(win_msgdlg)->action_area),
		       button, TRUE, TRUE, 0);
   gtk_widget_grab_default( button );
   gtk_widget_show( button );

   gtk_widget_show( win_msgdlg );
   gtk_main();
}


/******************
 * MessageDialog2 *
 ******************/
void cb_msgdlg_yes( GtkWidget *widget, GtkWidget *win )
{
   answer = 1;
   gtk_widget_destroy( win );
   gtk_main_quit();
}


void cb_msgdlg_no( GtkWidget *widget, GtkWidget *win )
{
   answer = 0;
   gtk_widget_destroy( win );
   gtk_main_quit();
}


int MessageDialog2( char *title, char *text, int icon )
{
   GtkWidget *win_msgdlg, *table;
   GtkWidget *label, *button, *xpmid_icon;
   GtkStyle  *style;
   GdkPixmap *xpm_icon;
   GdkBitmap *mask_icon;
   int       size, cols;
   char	     tmp[50];	

   answer = 0;

   size = strlen( text );
   cols = size / 4;

   win_msgdlg = gtk_dialog_new();
   gtk_grab_add( win_msgdlg );
   gtk_widget_realize( win_msgdlg );
   gtk_signal_connect( GTK_OBJECT(win_msgdlg), "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit), NULL );
   gtk_window_position( GTK_WINDOW(win_msgdlg), GTK_WIN_POS_CENTER );
   gtk_window_set_title( GTK_WINDOW(win_msgdlg), title );
   gtk_window_set_policy( GTK_WINDOW(win_msgdlg), FALSE, FALSE, FALSE );

   table = gtk_table_new( 1, cols, TRUE );
   gtk_container_add( GTK_CONTAINER(GTK_DIALOG(win_msgdlg)->vbox), table );
   gtk_widget_show( table );

   switch( icon )
   {
      case 1:
           sprintf( tmp, "%s%s", x48dir, EXCLAMATION_XPM );
           break;
      case 2:
           sprintf( tmp, "%s%s", x48dir, QUESTION_XPM );
           break;
      default:
           sprintf( tmp, "%s%s", x48dir, X48ICON_XPM );
           break;
   }
   style = gtk_widget_get_default_style();
   xpm_icon = gdk_pixmap_create_from_xpm( win_msgdlg->window, &mask_icon,
                                          &style->bg[GTK_STATE_NORMAL],
                                          tmp );
   xpmid_icon = gtk_pixmap_new( xpm_icon, mask_icon );
   gtk_table_attach_defaults( GTK_TABLE(table), xpmid_icon, 0, 1, 0, 1 );
   gtk_widget_show( xpmid_icon );

   label = gtk_label_new( text );
   gtk_misc_set_padding( GTK_MISC(label), size/2, 15 );
   gtk_table_attach_defaults( GTK_TABLE(table), label, 1, cols, 0, 1 );
   gtk_widget_show( label );

   button = gtk_button_new_with_label( "Yes" );
   gtk_signal_connect( GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(cb_msgdlg_yes), win_msgdlg );
   GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
   gtk_box_pack_start( GTK_BOX(GTK_DIALOG(win_msgdlg)->action_area),
	               button, TRUE, TRUE, 0 );
   gtk_widget_show( button );

   button = gtk_button_new_with_label( "No" );
   gtk_signal_connect( GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(cb_msgdlg_no), win_msgdlg );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX(GTK_DIALOG(win_msgdlg)->action_area),
		       button, TRUE, TRUE, 0);
   gtk_widget_grab_default( button );
   gtk_widget_show( button );

   gtk_widget_show( win_msgdlg );
   gtk_main();

   return answer;
}


/*******************
 * NotYetAvailable *
 *******************/
void NotYetAvailable( GtkWidget widget, char *title )
{
   state = 1;
   finish_int(),

   MessageDialog1( "Warning", "This option is not available yet", 1 );

   state = 0;
}
