/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: x48_gtk_keys.h
 * Description: Hp48 buttons: code, position, size and pixmaps
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#ifndef _X11_GTK_KEYS_H
#define _X11_GTK_KEYS_H 1


/* keys pixmaps */
#include "../pixmaps/nkeys.xpm"
#include "../pixmaps/ykeys.xpm"


/* keys */
struct keys_t {
                       short        pressed, key_down;
                       int          code;
                       gint         x, y;
                       gint         w, h;
                       char         **nkey_xpm, **ykey_xpm;
                       GdkPixmap    *xpm_n, *xpm_y;
                     } keys[NUMKEYS] =
{
    { 0, 0, 0x14, 8, 187, 37, 26, nkey01_xpm, ykey01_xpm },       /* A */
    { 0, 0, 0x84, 58, 187, 37, 26, nkey02_xpm, ykey02_xpm },      /* B */
    { 0, 0, 0x83, 108, 187, 37, 26, nkey03_xpm, ykey03_xpm },     /* C */
    { 0, 0, 0x82, 158, 187, 37, 26, nkey04_xpm, ykey04_xpm },     /* D */
    { 0, 0, 0x81, 208, 187, 37, 26, nkey05_xpm, ykey05_xpm },     /* E */
    { 0, 0, 0x80, 258, 187, 37, 26, nkey06_xpm, ykey06_xpm },     /* F */
    { 0, 0, 0x24, 8, 224, 37, 26, nkey07_xpm, ykey07_xpm },       /* MTH */
    { 0, 0, 0x74, 58, 224, 37, 26, nkey08_xpm, ykey08_xpm },      /* PRG */
    { 0, 0, 0x73, 108, 224, 37, 26, nkey09_xpm, ykey09_xpm },     /* CST */
    { 0, 0, 0x72, 158, 224, 37, 26, nkey10_xpm, ykey10_xpm },     /* VAR */
    { 0, 0, 0x71, 208, 224, 37, 26, nkey11_xpm, ykey11_xpm },     /* UP */
    { 0, 0, 0x70, 258, 224, 37, 26, nkey12_xpm, ykey12_xpm },     /* NXT */
    { 0, 0, 0x04, 8, 261, 37, 26, nkey13_xpm, ykey13_xpm },       /* ' */
    { 0, 0, 0x64, 58, 261, 37, 26, nkey14_xpm, ykey14_xpm },      /* STO */
    { 0, 0, 0x63, 108, 261, 37, 26, nkey15_xpm, ykey15_xpm },     /* EVAL */
    { 0, 0, 0x62, 158, 261, 37, 26, nkey16_xpm, ykey16_xpm },     /* LEFT */
    { 0, 0, 0x61, 208, 261, 37, 26, nkey17_xpm, ykey17_xpm },     /* DOWN */
    { 0, 0, 0x60, 258, 261, 37, 26, nkey18_xpm, ykey18_xpm },     /* RIGHT */
    { 0, 0, 0x34, 8, 298, 37, 26, nkey19_xpm, ykey19_xpm },       /* SIN */
    { 0, 0, 0x54, 58, 298, 37, 26, nkey20_xpm, ykey20_xpm },      /* COS */
    { 0, 0, 0x53, 108, 298, 37, 26, nkey21_xpm, ykey21_xpm },     /* TAN */
    { 0, 0, 0x52, 158, 298, 37, 26, nkey22_xpm, ykey22_xpm },     /* SQRT */
    { 0, 0, 0x51, 208, 298, 37, 26, nkey23_xpm, ykey23_xpm },     /* ^ */
    { 0, 0, 0x50, 258, 298, 37, 26, nkey24_xpm, ykey24_xpm },     /* INV */
    { 0, 0, 0x44, 8, 335, 87, 26, nkey25_xpm, ykey25_xpm },       /* ENTER */
    { 0, 0, 0x43, 108, 335, 37, 26, nkey26_xpm, ykey26_xpm },     /* +/- */
    { 0, 0, 0x42, 158, 335, 37, 26, nkey27_xpm, ykey27_xpm },     /* EEX */
    { 0, 0, 0x41, 208, 335, 37, 26, nkey28_xpm, ykey28_xpm },     /* DEL */
    { 0, 0, 0x40, 258, 335, 37, 26, nkey29_xpm, ykey29_xpm },     /* <= */
    { 0, 0, 0x35, 8, 372, 37, 26, nkey30_xpm, ykey30_xpm },       /* ALPHA */
    { 0, 0, 0x33, 66, 372, 48, 26, nkey31_xpm, ykey31_xpm },      /* 7 */
    { 0, 0, 0x32, 126, 372, 48, 26, nkey32_xpm, ykey32_xpm },     /* 8 */
    { 0, 0, 0x31, 186, 372, 48, 26, nkey33_xpm, ykey33_xpm },     /* 9 */
    { 0, 0, 0x30, 246, 372, 48, 26, nkey34_xpm, ykey34_xpm },     /* / */
    { 0, 0, 0x25, 8, 409, 37, 26, nkey35_xpm, ykey35_xpm },       /* LS */
    { 0, 0, 0x23, 66, 409, 48, 26, nkey36_xpm, ykey36_xpm },      /* 4 */
    { 0, 0, 0x22, 126, 409, 48, 26, nkey37_xpm, ykey37_xpm },     /* 5 */
    { 0, 0, 0x21, 186, 409, 48, 26, nkey38_xpm, ykey38_xpm },     /* 6 */
    { 0, 0, 0x20, 246, 409, 48, 26, nkey39_xpm, ykey39_xpm },     /* * */
    { 0, 0, 0x15, 8, 446, 37, 26, nkey40_xpm, ykey40_xpm },       /* RS */
    { 0, 0, 0x13, 66, 446, 48, 26, nkey41_xpm, ykey41_xpm },      /* 1 */
    { 0, 0, 0x12, 126, 446, 48, 26, nkey42_xpm, ykey42_xpm },     /* 2 */
    { 0, 0, 0x11, 186, 446, 48, 26, nkey43_xpm, ykey43_xpm },     /* 3 */
    { 0, 0, 0x10, 246, 446, 48, 26, nkey44_xpm, ykey44_xpm },     /* - */
    { 0, 0, 0x8000, 8, 483, 37, 26, nkey45_xpm, ykey45_xpm },     /* ON */
    { 0, 0, 0x03, 66, 483, 48, 26, nkey46_xpm, ykey46_xpm },      /* 0 */
    { 0, 0, 0x02, 126, 483, 48, 26, nkey47_xpm, ykey47_xpm },     /* . */
    { 0, 0, 0x01, 186, 483, 48, 26, nkey48_xpm, ykey48_xpm },     /* SPC */
    { 0, 0, 0x00, 246, 483, 48, 26, nkey49_xpm, ykey49_xpm }      /* + */
};


#endif /* _X11_GTK_KEYS_H */

