/*
 * Program: x48 with GTK support
 * Version: 0.5.0 (GTK)
 * File: x48_gtk_menu.c
 * Description: functions in menu buttons
 * History:
 *          Ver              Modified                Date
 *          ===  ================================  ========
 */


#include <config.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "global.h"
#include "hp48.h"
#include "copyright.h"
#include "x48_gtk.h"
#include "x48_gtk_menu.h"


/* for file selection */
char filename[1024], objs_path[1024] = "";
/* for settings */
int  s_opt_show_intro, s_opt_ask_save, s_opt_save, s_opt_save_cfg;
int  s_opt_verbose, s_opt_mnemonics_hp;
int  s_opt_serial, s_opt_terminal;
char s_opt_serial_line[50], s_terminal_line[50];
int  s_opt_port1w, s_opt_port2w;
int  s_opt_time_accurate, s_opt_timer1_period;


/****************************************************
 **************** menu_load_object ******************
 ****************************************************/
void filesel_quit( GtkWidget *widget, GtkFileSelection *fs )
{
   strcpy( filename, "" );
   gtk_widget_destroy( GTK_WIDGET(fs) );
/*   gtk_main_quit(); */
}


void filesel_ok( GtkWidget *widget, GtkFileSelection *fs )
{
   strcpy( filename, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)) );
   gtk_widget_destroy( GTK_WIDGET(fs) );
/*   gtk_main_quit(); */
}


void menu_load_object()
{
   GtkWidget *win_filesel;
   char        *obj_name, *buf,* buf2, new_file[1024];

   /* stop emulation */
   state = 1;
   finish_int();

   /* get path to save object */
   sprintf( new_file, "%s", objs_path );

   /* file selection */
   win_filesel = gtk_file_selection_new( "Load HP48 Object" );
   gtk_grab_add( win_filesel );
   gtk_file_selection_hide_fileop_buttons( GTK_FILE_SELECTION(win_filesel) );
   gtk_window_set_policy( GTK_WINDOW(win_filesel), FALSE, FALSE, FALSE );
   gtk_window_position( GTK_WINDOW(win_filesel), GTK_WIN_POS_MOUSE );
   gtk_signal_connect( GTK_OBJECT(win_filesel), "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit), NULL );
   gtk_signal_connect( GTK_OBJECT(GTK_FILE_SELECTION(win_filesel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC(filesel_quit),
                       win_filesel );
   gtk_signal_connect( GTK_OBJECT(GTK_FILE_SELECTION(win_filesel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC(filesel_ok),
                       win_filesel );
   gtk_file_selection_set_filename( GTK_FILE_SELECTION(win_filesel),
                                    new_file );
   gtk_widget_show( win_filesel );
   gtk_main();

   /* end load object if no file supplied */
   if( !strcmp(filename, "") )
   {
      state = 0;
      return;
   }

   /* get object file path and name */
   if( !(obj_name = (char *) strrchr(filename, '/')) )
      strcpy( obj_name, filename );
   else
      obj_name++;
   buf = filename;
   buf2 = objs_path;
   while( buf < obj_name )
      *buf2++ = *buf++;
   *buf2 = '\0';

   /* check errors */
   switch( LoadObject(filename) )
   {
      case 0:
           if( opt_verbose )
              printf( "%s:\t<%s> loaded\n", x48name, filename );
           break;
      case -1:
           MessageDialog1( "Load Object", "ERROR:  Can't open file", 1 );
           break;
      case -2:
           MessageDialog1( "Load Object", "ERROR:  Can't stat file", 1 );
           break;
      case -3:
           MessageDialog1( "Load Object", "ERROR:  File too big", 1 );
           break;
      case -4:
           MessageDialog1( "Load Object", "ERROR:  Can't read file header", 1 );
           break;
      case -5:
           MessageDialog1( "Load Object", "ERROR:  Can't alloc enough memory", 1 );
           break;
      case -6:
           MessageDialog1( "Load Object", "ERROR:  Can't read from file", 1 );
           break;
      case -7:
           MessageDialog1( "Load Object", "ERROR:  HP48 has not enough free memory", 1 );
           break;
      default:
           break;
   }

   /* continue emulation */
   state = 0;
}


/****************************************************
 **************** menu_save_object ******************
 ****************************************************/
void menu_save_object()
{
   GtkWidget   *win_filesel;
   struct stat st;
   word_20     obj;
   char        *obj_name, *buf, *buf2, new_file[1024], tmp[100];;

   /* stop emulation */
   state = 1;
   finish_int();

   /* check if object in stack level #1 */
   if( !(obj = RPL_Pick(1)) )
   {
      MessageDialog1( "Save Object", "ERROR:  Too few arguments", 1 );
      state = 0;
      return;
   }

   /* get path to save object */
   sprintf( new_file, "%s%s", objs_path, "file.new" );

   /* file selection */
   win_filesel = gtk_file_selection_new( "Save HP48 Object" );
   gtk_grab_add( win_filesel );
   gtk_file_selection_show_fileop_buttons( GTK_FILE_SELECTION(win_filesel) );
   gtk_window_set_policy( GTK_WINDOW(win_filesel), FALSE, FALSE, FALSE );
   gtk_window_position( GTK_WINDOW(win_filesel), GTK_WIN_POS_MOUSE );
   gtk_signal_connect( GTK_OBJECT(win_filesel), "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit), NULL );
   gtk_signal_connect( GTK_OBJECT(GTK_FILE_SELECTION(win_filesel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC(filesel_quit),
                       win_filesel );
   gtk_signal_connect( GTK_OBJECT(GTK_FILE_SELECTION(win_filesel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC(filesel_ok),
                       win_filesel );
   gtk_file_selection_set_filename( GTK_FILE_SELECTION(win_filesel),
                                    new_file );

   gtk_widget_show( win_filesel );
   gtk_main();

   /* end save object if no file supplied */
   if( !strcmp(filename, "") )
   {
      state = 0;
      return;
   }

   /* get object file name */
   if( !(obj_name = (char *) strrchr(filename, '/')) )
      strcpy( obj_name, filename );
   else
      obj_name++;

   /* check if file exists */
   if( !(stat(filename, &st) < 0) )
   {
      sprintf( tmp, " Overwrite '%s'? ", obj_name );
      if( !(MessageDialog2("Save Object", tmp, 1)) )
      {
         state = 0;
         return;
      }
   }

   /* get object file path */
   buf = filename;
   buf2 = objs_path;
   while( buf < obj_name )
      *buf2++ = *buf++;
   *buf2 = '\0';

   /* check errors */
   switch( SaveObject(obj, filename) )
   {
      case 0:
           if( opt_verbose )
              printf( "%s:\t<%s> saved\n", x48name, filename );
           break;
      case -1:
           MessageDialog1( "Save Object", "ERROR:  Can't open file", 1 );
           break;
      case -2:
           MessageDialog1( "Save Object", "ERROR:  Can't write in file", 1 );
           break;
      default:
           break;
   }

   /* continue emulation */
   state = 0;
}


/****************************************************
 ***************** menu_save_state ******************
 ****************************************************/
void menu_save_state()
{
   state = 1;
   finish_int();

   if( opt_verbose )
      printf( "\n" );
   write_files();
   if( opt_verbose )
      printf( "\n" );

   state = 0;
}


/****************************************************
 ****************** menu_settings *******************
 ****************************************************/
void prepare_settings_data()
{
   s_opt_show_intro = opt_show_intro;
   s_opt_ask_save = opt_ask_save;
   s_opt_save = opt_save;
   s_opt_save_cfg = opt_save_cfg;
   s_opt_verbose = opt_verbose;
   s_opt_mnemonics_hp = opt_mnemonics_hp;
   s_opt_serial = opt_serial;
   strcpy( s_opt_serial_line, opt_serial_line );
   s_opt_terminal = opt_terminal;
   strcpy( s_terminal_line, terminal_line );
   s_opt_port1w = opt_port1w;
   s_opt_port2w = opt_port2w;
   s_opt_time_accurate = opt_time_accurate;
   s_opt_timer1_period = opt_timer1_period;
}

void cb_settings_ok( GtkWidget *widget, GtkWidget *win )
{
   opt_show_intro = s_opt_show_intro;
   opt_ask_save = s_opt_ask_save;
   opt_save = s_opt_save;
   opt_save_cfg = s_opt_save_cfg;
   opt_verbose = s_opt_verbose;
   opt_mnemonics_hp = s_opt_mnemonics_hp;

   opt_serial = s_opt_serial;
   opt_terminal = s_opt_terminal;
   if( ( !strcmp(opt_serial_line, s_opt_serial_line) && opt_serial ) || \
       ( !strcmp(terminal_line, s_terminal_line) && opt_terminal ) )
   {
      strcpy( opt_serial_line, s_opt_serial_line );
      strcpy( terminal_line, s_terminal_line );
      init_serial();
   }
   else
   {
      strcpy( opt_serial_line, s_opt_serial_line );
      strcpy( terminal_line, s_terminal_line );
   }

   if( opt_port1w != s_opt_port1w )
   {
      opt_port1w = s_opt_port1w;
      /* init_port1w */
   }
   else
      opt_port1w = s_opt_port1w;
   if( opt_port2w != s_opt_port2w )
   {
      opt_port2w = s_opt_port2w;
      /* init_port2w */
   }
   else
      opt_port2w = s_opt_port2w;

   if( ( opt_time_accurate != s_opt_time_accurate ) || \
       ( opt_timer1_period != s_opt_timer1_period ) )
   {
      opt_time_accurate = s_opt_time_accurate;
      opt_timer1_period = s_opt_timer1_period;
      /* init_timers(); */
   }
   else
   {
      opt_time_accurate = s_opt_time_accurate;
      opt_timer1_period = s_opt_timer1_period;
   }

   gtk_widget_destroy( win );
fprintf( stderr, "Line: %s, Terminal: %s\n", opt_serial_line, terminal_line );
}

void cb_cbtn_show_intro()
{
   s_opt_show_intro = s_opt_show_intro ? FALSE : TRUE;
}

void cb_cbtn_ask_save()
{
   s_opt_ask_save = s_opt_ask_save ? FALSE : TRUE;
}

void cb_cbtn_save()
{
   s_opt_save = s_opt_save ? FALSE : TRUE;
}

void cb_cbtn_save_cfg()
{
   s_opt_save_cfg = s_opt_save_cfg ? FALSE : TRUE;
}

void cb_rbtn_info1()
{
   s_opt_verbose = 1;
}

void cb_rbtn_info2()
{
   s_opt_verbose = 0;
}

void cb_rbtn_mnemonics1()
{
   s_opt_mnemonics_hp = 1;
}

void cb_rbtn_mnemonics2()
{
   s_opt_mnemonics_hp = 0;
}

void cb_cbtn_serial( GtkWidget *widget, GtkWidget *entry )
{
   s_opt_serial = s_opt_serial ? FALSE : TRUE;
   if( s_opt_serial )
      gtk_widget_show( entry );
   else
      gtk_widget_hide( entry );
}

void cb_entry_serial( GtkWidget *widget, GtkWidget *entry )
{
   strcpy( s_opt_serial_line, gtk_entry_get_text(GTK_ENTRY(entry)) );
}

void cb_cbtn_terminal( GtkWidget *widget, GtkWidget *entry )
{
   s_opt_terminal = s_opt_terminal ? FALSE : TRUE;
   if( s_opt_terminal )
      gtk_widget_show( entry );
   else
      gtk_widget_hide( entry );
}

void cb_cbtn_port1w()
{
   s_opt_port1w = s_opt_port1w ? FALSE : TRUE;
}

void cb_cbtn_port2w()
{
   s_opt_port2w = s_opt_port2w ? FALSE : TRUE;
}

void cb_cbtn_time_acc()
{
   s_opt_time_accurate = s_opt_time_accurate ? FALSE : TRUE;
}

void cb_entry_timer1_period()
{
}


void menu_settings()
{
   GtkWidget *win_settings, *table;
   GtkWidget *frame, *vtbox;
   GtkWidget *cbtn_show_intro, *cbtn_ask_save, *cbtn_save, *cbtn_save_cfg;
   GtkWidget *rbtn_info, *rbtn_mnemonics;
   GtkWidget *table2, *cbtn_serial, *cbtn_terminal,
             *entry_serial, *entry_terminal;
   GtkWidget *cbtn_port1w, *cbtn_port2w;
   GtkWidget *cbtn_time_acc, *label, *entry_timer1_period;
   GtkWidget *button;

   state = 1;
   finish_int();


   prepare_settings_data();

   win_settings = gtk_dialog_new();
   gtk_grab_add( win_settings );
   gtk_widget_realize( win_settings );
   gtk_signal_connect( GTK_OBJECT(win_settings), "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit), NULL );
   gtk_widget_set_usize( win_settings, 425, 500 );
   gtk_window_position( GTK_WINDOW(win_settings), GTK_WIN_POS_CENTER );
   gtk_window_set_title( GTK_WINDOW(win_settings), "Settings" );
   gtk_window_set_policy( GTK_WINDOW(win_settings), FALSE, FALSE, FALSE );

   table = gtk_table_new( 19, 20, TRUE );
   gtk_container_add( GTK_CONTAINER(GTK_DIALOG(win_settings)->vbox), table );
   gtk_widget_show( table );

   frame = gtk_frame_new( "General" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 1, 19, 1, 6 );
   gtk_widget_show( frame );
   vtbox = gtk_vbox_new( FALSE, 0 );
   gtk_container_border_width( GTK_CONTAINER(vtbox), 5 );
   gtk_container_add( GTK_CONTAINER(frame), vtbox );
   gtk_widget_show( vtbox );
   cbtn_show_intro = gtk_check_button_new_with_label(
                                          "Show Intro window at start" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_show_intro),
                                s_opt_show_intro ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_show_intro), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_show_intro), NULL );
   gtk_container_add( GTK_CONTAINER(vtbox), cbtn_show_intro );
   gtk_widget_show( cbtn_show_intro );
   cbtn_ask_save = gtk_check_button_new_with_label(
                                        "Ask for saving state at exit" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_ask_save),
                                s_opt_ask_save ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_ask_save), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_ask_save), NULL );
   gtk_container_add( GTK_CONTAINER(vtbox), cbtn_ask_save );
   gtk_widget_show( cbtn_ask_save );
   cbtn_save = gtk_check_button_new_with_label(
                                    "Save state at exit without asking" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_save),
                                s_opt_save ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_save), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_save), NULL );
   gtk_container_add( GTK_CONTAINER(vtbox), cbtn_save );
   gtk_widget_show( cbtn_save );
   cbtn_save_cfg = gtk_check_button_new_with_label(
                                        "Save configuration at exit" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_save_cfg),
                                s_opt_save_cfg ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_save_cfg), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_save_cfg), NULL );
   gtk_container_add( GTK_CONTAINER(vtbox), cbtn_save_cfg );
   gtk_widget_show( cbtn_save_cfg );

   frame = gtk_frame_new( "Information" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 1, 8, 7, 10 );
   gtk_widget_show( frame );
   vtbox = gtk_vbox_new( FALSE, 0 );
   gtk_container_add( GTK_CONTAINER(frame), vtbox );
   gtk_widget_show( vtbox );
   rbtn_info = gtk_radio_button_new_with_label( NULL, "Run verbosely" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(rbtn_info),
                                s_opt_verbose ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(rbtn_info), "clicked",
                       GTK_SIGNAL_FUNC(cb_rbtn_info1), NULL );
   gtk_box_pack_start( GTK_BOX(vtbox), rbtn_info, TRUE, TRUE, 0 );
   gtk_widget_show( rbtn_info );
   rbtn_info = gtk_radio_button_new_with_label(
                         gtk_radio_button_group(GTK_RADIO_BUTTON(rbtn_info)),
                         "Run quietly" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(rbtn_info),
                                s_opt_verbose ? FALSE : TRUE );
   gtk_signal_connect( GTK_OBJECT(rbtn_info), "clicked",
                       GTK_SIGNAL_FUNC(cb_rbtn_info2), NULL );
   gtk_box_pack_start( GTK_BOX(vtbox), rbtn_info, TRUE, TRUE, 0 );
   gtk_widget_show( rbtn_info );

   frame = gtk_frame_new( "Disassembler Mnemonics" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 9, 19, 7, 10 );
   gtk_widget_show( frame );
   vtbox = gtk_vbox_new( FALSE, 0 );
   gtk_container_add( GTK_CONTAINER(frame), vtbox );
   gtk_widget_show( vtbox );
   rbtn_mnemonics = gtk_radio_button_new_with_label( NULL, "HP" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(rbtn_mnemonics),
                                s_opt_mnemonics_hp ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(rbtn_mnemonics), "clicked",
                       GTK_SIGNAL_FUNC(cb_rbtn_mnemonics1), NULL );
   gtk_box_pack_start( GTK_BOX(vtbox), rbtn_mnemonics, TRUE, TRUE, 0 );
   gtk_widget_show( rbtn_mnemonics );
   rbtn_mnemonics = gtk_radio_button_new_with_label(
                        gtk_radio_button_group(GTK_RADIO_BUTTON(rbtn_mnemonics)),
                        "Class" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(rbtn_mnemonics),
                                s_opt_mnemonics_hp ? FALSE : TRUE );
   gtk_signal_connect( GTK_OBJECT(rbtn_mnemonics), "clicked",
                       GTK_SIGNAL_FUNC(cb_rbtn_mnemonics2), NULL );
   gtk_box_pack_start( GTK_BOX(vtbox), rbtn_mnemonics, TRUE, TRUE, 0 );
   gtk_widget_show( rbtn_mnemonics );

   frame = gtk_frame_new( "Comms" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 1, 19, 11, 14 );
   gtk_widget_show( frame );
   table2 = gtk_table_new( 2, 12, TRUE );
   gtk_container_border_width( GTK_CONTAINER(table2), 0 );
   gtk_container_add( GTK_CONTAINER(frame), table2 );
   gtk_widget_show( table2 );
   cbtn_serial = gtk_check_button_new_with_label( "Use Serial Line" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_serial),
                                s_opt_serial ? TRUE : FALSE );
   gtk_table_attach_defaults( GTK_TABLE(table2), cbtn_serial, 0, 5, 0, 1 );
   gtk_widget_show( cbtn_serial );
   entry_serial = gtk_entry_new_with_max_length( 17 );
   gtk_entry_set_text( GTK_ENTRY(entry_serial), s_opt_serial_line );
   gtk_signal_connect( GTK_OBJECT(entry_serial), "activate",
                       GTK_SIGNAL_FUNC(cb_entry_serial), entry_serial );
   gtk_table_attach_defaults( GTK_TABLE(table2), entry_serial, 6, 11, 0, 1 );
   if( s_opt_serial )
      gtk_widget_show( entry_serial );
   gtk_signal_connect( GTK_OBJECT(cbtn_serial), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_serial), entry_serial );
   cbtn_terminal = gtk_check_button_new_with_label( "Use Terminal Line" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_terminal),
                                s_opt_terminal ? TRUE : FALSE );
   gtk_table_attach_defaults( GTK_TABLE(table2), cbtn_terminal, 0, 5, 1, 2 );
   gtk_widget_show( cbtn_terminal );
   entry_terminal = gtk_entry_new_with_max_length( 17 );
   gtk_entry_set_text( GTK_ENTRY(entry_terminal), s_terminal_line );
   gtk_entry_set_editable( GTK_ENTRY(entry_terminal), FALSE );
   gtk_table_attach_defaults( GTK_TABLE(table2), entry_terminal, 6, 11, 1, 2 );
   if( s_opt_terminal )
      gtk_widget_show( entry_terminal );
   gtk_signal_connect( GTK_OBJECT(cbtn_terminal), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_terminal), entry_terminal );

   frame = gtk_frame_new( "Ports" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 1, 8, 15, 18 );
   gtk_widget_show( frame );
   table2 = gtk_table_new( 2, 1, TRUE );
   gtk_container_add( GTK_CONTAINER(frame), table2 );
   gtk_widget_show( table2 );
   cbtn_port1w = gtk_check_button_new_with_label( "Port1 Writeable" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_port1w),
                                s_opt_port1w ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_port1w), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_port1w), NULL );
   gtk_table_attach_defaults( GTK_TABLE(table2), cbtn_port1w, 0, 1, 0, 1 );
   gtk_widget_show( cbtn_port1w );
   cbtn_port2w = gtk_check_button_new_with_label( "Port2 Writeable" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_port2w),
                                s_opt_port2w ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_port2w), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_port2w), NULL );
   gtk_table_attach_defaults( GTK_TABLE(table2), cbtn_port2w, 0, 1, 1, 2 );
   gtk_widget_show( cbtn_port2w );

   frame = gtk_frame_new( "Timers" );
   gtk_table_attach_defaults( GTK_TABLE(table), frame, 9, 19, 15, 18 );
   gtk_widget_show( frame );
   table2 = gtk_table_new( 2, 10, TRUE );
   gtk_container_add( GTK_CONTAINER(frame), table2 );
   gtk_widget_show( table2 );
   cbtn_time_acc = gtk_check_button_new_with_label( "Accurate Time" );
   gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_time_acc),
                                s_opt_time_accurate ? TRUE : FALSE );
   gtk_signal_connect( GTK_OBJECT(cbtn_time_acc), "clicked",
                       GTK_SIGNAL_FUNC(cb_cbtn_time_acc), NULL );
   gtk_table_attach_defaults( GTK_TABLE(table2), cbtn_time_acc, 0, 6, 0, 1 );
   gtk_widget_show( cbtn_time_acc );
   label = gtk_label_new( "Timer 1 Period:" );
   gtk_table_attach_defaults( GTK_TABLE(table2), label, 0, 6, 1, 2 );
   gtk_widget_show( label );
   entry_timer1_period = gtk_entry_new_with_max_length( 5 );
   gtk_entry_set_text( GTK_ENTRY(entry_timer1_period), "gugugu" );
   gtk_signal_connect( GTK_OBJECT(entry_timer1_period), "activate",
                       GTK_SIGNAL_FUNC(cb_entry_timer1_period), NULL );
   gtk_table_attach_defaults( GTK_TABLE(table2), entry_timer1_period,
                              6, 9, 1, 2 );
   gtk_widget_show( entry_timer1_period );


   button = gtk_button_new_with_label( "Ok" );
   gtk_signal_connect( GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(cb_settings_ok), win_settings );
   GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
   gtk_box_pack_start( GTK_BOX(GTK_DIALOG(win_settings)->action_area),
	               button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( button );
   gtk_widget_show( button );

   button = gtk_button_new_with_label( "Cancel" );
   gtk_signal_connect_object( GTK_OBJECT(button), "clicked",
		              GTK_SIGNAL_FUNC(gtk_widget_destroy),
                              GTK_OBJECT(win_settings) );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX(GTK_DIALOG(win_settings)->action_area),
		       button, TRUE, TRUE, 0);
   gtk_widget_show( button );


   gtk_widget_show( win_settings );
   gtk_main();

   state = 0;
}


/****************************************************
 ******************* menu_reset *********************
 ****************************************************/
void menu_reset()
{
   state = 1;
   finish_int();

   if( MessageDialog2("Reset Calculator?", " Reset Calculator? ", 2) )
   {
      if( opt_verbose )
         printf( "Reseting Calculator\n" );
      saturn.PC = 0x01FC6;                    /* SoftStart */
   }

   state = 0;
}


/****************************************************
 ******************** menu_show *********************
 ****************************************************/
void cb_cbtn_showintro( GtkWidget *widget, gpointer *data )
{
   if( opt_show_intro )
      opt_show_intro = 0;
   else
      opt_show_intro = 1;
}


int about_quit( GtkWidget *widget, gpointer *data )
{
   gtk_grab_remove( widget );
   gtk_widget_destroy( widget );
   gtk_main_quit();
   return FALSE;
}


void menu_about()
{
   GtkWidget *win_about, *table, *notebook;
   GtkWidget *frame, *label, *table2, *viewport;
   GtkWidget *xpmid_icon, *label2;
   GtkStyle  *style;
   GdkPixmap *xpm_icon;
   GdkBitmap *mask_icon;
   GtkWidget *text, *box1, *box2, *vscrollbar;
   GdkColor  *color;
   GdkFont   *font;
   GtkWidget *btn_cont;
   char      tmp[255];

   state = 1;
   change_state = 1;

   win_about = gtk_widget_new( gtk_window_get_type(),
			       "GtkObject::user_data", NULL,
			       "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
			       "GtkWindow::title", PROGNAME"     - ABOUT -",
			       "GtkWindow::allow_grow", FALSE,
			       "GtkWindow::allow_shrink", FALSE,
			       "GtkContainer::border_width", 10,
			       NULL);
   gtk_grab_add( win_about );
   gtk_widget_set_usize( win_about, 580, 360 );
   gtk_window_position( GTK_WINDOW(win_about), GTK_WIN_POS_CENTER );
   gtk_signal_connect( GTK_OBJECT(win_about), "destroy",
                       GTK_SIGNAL_FUNC(about_quit), NULL );

   table = gtk_table_new( 8, 7, TRUE );
   gtk_table_set_row_spacings( GTK_TABLE(table), 10 );
   gtk_container_add( GTK_CONTAINER(win_about), table );
   gtk_widget_show( table );

   notebook = gtk_notebook_new();
   gtk_notebook_set_tab_pos( GTK_NOTEBOOK(notebook), GTK_POS_TOP );
   gtk_table_attach_defaults( GTK_TABLE(table), notebook, 0, 7, 0, 7 );
   gtk_widget_show( notebook );

   /* 1st. frame: About */
   frame = gtk_frame_new( "About" );
   gtk_container_border_width( GTK_CONTAINER(frame), 5 );
   gtk_widget_set_usize( frame, 400, 150 );
   gtk_widget_show( frame );
   label = gtk_label_new( "About" );
   gtk_notebook_append_page( GTK_NOTEBOOK(notebook), frame, label );
   gtk_widget_show( label );
   table2 = gtk_table_new( 6, 9, TRUE );
   gtk_container_add( GTK_CONTAINER(frame), table2 );
   gtk_widget_show( table2 );
   style = gtk_widget_get_default_style();
   gtk_widget_realize( frame );
   sprintf( tmp, "%s%s", x48dir, HP48_IMAGE_XPM );
   xpm_icon = gdk_pixmap_create_from_xpm( frame->window, &mask_icon,
                                          &style->bg[GTK_STATE_NORMAL],
                                          tmp );
   xpmid_icon = gtk_pixmap_new( xpm_icon, mask_icon );
   gtk_table_attach_defaults( GTK_TABLE(table2), xpmid_icon, 0, 4, 0, 6 );
   gtk_widget_show( xpmid_icon );
   viewport = gtk_viewport_new( NULL, NULL );
   gtk_widget_set_usize( viewport, 50, 25 );
   gtk_viewport_set_shadow_type( GTK_VIEWPORT(viewport), GTK_SHADOW_IN );
   gtk_table_attach_defaults( GTK_TABLE(table2), viewport, 5, 8, 0, 1 );
   gtk_widget_show( viewport );
   label2 = gtk_label_new( PROGNAME );
   gtk_container_add( GTK_CONTAINER(viewport), label2 );
   gtk_widget_show( label2 );
   label2 = gtk_label_new( AUTHOR_NAME_1 );
   gtk_table_attach_defaults( GTK_TABLE(table2), label2, 4, 9, 2, 3 );
   gtk_widget_show( label2 );
   label2 = gtk_label_new( AUTHOR_NAME_2"   " );
   gtk_table_attach_defaults( GTK_TABLE(table2), label2, 4, 9, 3, 4 );
   gtk_widget_show( label2 );

   /* color for text of 2nd. and 3rd. frames */
   color = (GdkColor *) malloc( sizeof (GdkColor) );
   color->red = 10 * (65535/255);
   color->green = 170 * (65535/255);
   color->blue = 10 * (65535/255);
   color->pixel = (gulong) ( 10*65536 + 170*256 + 10 );
   gdk_color_alloc( gtk_widget_get_colormap(win_about), color );

   /* 2nd. frame: Copyright */
   frame = gtk_frame_new( "Copyright" );
   gtk_container_border_width( GTK_CONTAINER(frame), 5 );
   gtk_widget_set_usize( frame, 400, 150 );
   gtk_widget_show( frame );
   label = gtk_label_new( "Copyright" );
   gtk_notebook_append_page( GTK_NOTEBOOK(notebook), frame, label );
   gtk_widget_show( label );
   box1 = gtk_vbox_new( FALSE, 0 );
   gtk_container_add( GTK_CONTAINER(frame), box1 );
   gtk_widget_show( box1 );
   box2 = gtk_vbox_new( FALSE, 10 );
   gtk_container_border_width( GTK_CONTAINER(box2), 10 );
   gtk_box_pack_start( GTK_BOX(box1), box2, TRUE, TRUE, 0 );
   gtk_widget_show( box2 );
   table2 = gtk_table_new( 2, 2, FALSE );
   gtk_table_set_row_spacing( GTK_TABLE(table2), 0, 2 );
   gtk_table_set_col_spacing( GTK_TABLE(table2), 0, 2 );
   gtk_box_pack_start( GTK_BOX(box2), table2, TRUE, TRUE, 0 );
   gtk_widget_show( table2 );
   text = gtk_text_new( NULL, NULL );
   gtk_text_set_editable( GTK_TEXT(text), FALSE );
   gtk_table_attach( GTK_TABLE( table2 ), text, 0, 1, 0, 1,
                     GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                     GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0 );
   gtk_widget_show( text );
   vscrollbar = gtk_vscrollbar_new( GTK_TEXT (text)->vadj );
   gtk_table_attach( GTK_TABLE(table2), vscrollbar, 1, 2, 0, 1,
		     GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0 );
   gtk_widget_show( vscrollbar );
   gtk_text_freeze( GTK_TEXT(text) );
   gtk_widget_realize( text );
   font = gdk_font_load( FONT_ABOUT_1 );
   gtk_text_insert( GTK_TEXT(text), font,
                    color,
                    &text->style->white,
                    copyright, -1 );
   gtk_text_thaw( GTK_TEXT(text) );

   /* 3rd. frame: Warranty */
   frame = gtk_frame_new( "Warranty" );
   gtk_container_border_width( GTK_CONTAINER(frame), 5 );
   gtk_widget_set_usize( frame, 400, 150 );
   gtk_widget_show( frame );
   label = gtk_label_new( "Warranty" );
   gtk_notebook_append_page( GTK_NOTEBOOK(notebook), frame, label );
   gtk_widget_show( label );
   box1 = gtk_vbox_new( FALSE, 0 );
   gtk_container_add( GTK_CONTAINER(frame), box1 );
   gtk_widget_show( box1 );
   box2 = gtk_vbox_new( FALSE, 10 );
   gtk_container_border_width( GTK_CONTAINER(box2), 10 );
   gtk_box_pack_start( GTK_BOX(box1), box2, TRUE, TRUE, 0 );
   gtk_widget_show( box2 );
   table2 = gtk_table_new( 2, 2, FALSE );
   gtk_table_set_row_spacing( GTK_TABLE(table2), 0, 2 );
   gtk_table_set_col_spacing( GTK_TABLE(table2), 0, 2 );
   gtk_box_pack_start( GTK_BOX(box2), table2, TRUE, TRUE, 0 );
   gtk_widget_show( table2 );
   text = gtk_text_new( NULL, NULL );
   gtk_text_set_editable( GTK_TEXT(text), FALSE );
   gtk_table_attach( GTK_TABLE( table2 ), text, 0, 1, 0, 1,
                     GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                     GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0 );
   gtk_widget_show( text );
   vscrollbar = gtk_vscrollbar_new( GTK_TEXT (text)->vadj );
   gtk_table_attach( GTK_TABLE(table2), vscrollbar, 1, 2, 0, 1,
		     GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0 );
   gtk_widget_show( vscrollbar );
   gtk_text_freeze( GTK_TEXT(text) );
   gtk_widget_realize( text );
   font = gdk_font_load( FONT_ABOUT_2 );
   gtk_text_insert( GTK_TEXT(text), font,
                    color,
                    &text->style->white,
                    warranty, -1 );
   gtk_text_thaw( GTK_TEXT(text) );

   /* 'Show this window at start' check button */
   if( opt_show_intro && !saturn.rom )
   {
      GtkWidget *cbtn_showintro;

      cbtn_showintro = gtk_check_button_new_with_label(
                                       "Show this window at start" );
      gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(cbtn_showintro),
                                   opt_show_intro ? TRUE : FALSE );
      gtk_signal_connect( GTK_OBJECT(cbtn_showintro), "clicked",
                          GTK_SIGNAL_FUNC(cb_cbtn_showintro), NULL );
      gtk_table_attach_defaults( GTK_TABLE(table), cbtn_showintro,
                                 0, 3, 7, 8 );
      gtk_widget_show( cbtn_showintro );
   }

   /* 'Continue' button */
   btn_cont = gtk_button_new_with_label( "Continue" );
   gtk_signal_connect_object( GTK_OBJECT(btn_cont), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy),
                              GTK_OBJECT(win_about) );
   gtk_table_attach_defaults( GTK_TABLE(table), btn_cont, 6, 7, 7, 8 );
   GTK_WIDGET_SET_FLAGS( btn_cont, GTK_CAN_DEFAULT );
   gtk_widget_grab_default( btn_cont );
   gtk_widget_show( btn_cont );

   /* End of notebook */
   gtk_widget_show( win_about );
   gtk_main();

   state = 0;
}

